/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types.color;

import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;

public record HsbColor(float hue, float saturation, float brightness, int alpha) {
    public static HsbColor of(float hue, float saturation, float brightness, int alpha) {
        return new HsbColor(hue, saturation, brightness, alpha);
    }

    public static HsbColor fromRgb(int rgba) {
        float hue;
        float saturation;
        int r = ARGB.red((int)rgba);
        int g = ARGB.green((int)rgba);
        int b = ARGB.blue((int)rgba);
        int a = ARGB.alpha((int)rgba);
        int cmax = Math.max(Math.max(r, g), b);
        int cmin = Math.min(Math.min(r, g), b);
        float brightness = (float)cmax / 255.0f;
        float f = saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new HsbColor(hue, saturation, brightness, a);
    }

    public int toRgba() {
        return Mth.hsvToArgb((float)this.hue, (float)this.saturation, (float)this.brightness, (int)this.alpha);
    }

    public HsbColor withAlpha(int alpha) {
        return new HsbColor(this.hue, this.saturation, this.brightness, alpha);
    }

    public HsbColor withBrightness(float brightness) {
        return new HsbColor(this.hue, this.saturation, brightness, this.alpha);
    }

    public HsbColor withSaturation(float saturation) {
        return new HsbColor(this.hue, saturation, this.brightness, this.alpha);
    }

    public HsbColor withHue(float hue) {
        return new HsbColor(hue, this.saturation, this.brightness, this.alpha);
    }
}

