/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types.color;

import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbState;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class HueSelector
extends BaseWidget {
    private final HsbState state;

    public HueSelector(int width, int height, HsbState state) {
        super(width, height);
        this.state = state;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.getWidth(); ++i) {
            graphics.fill(this.getX() + i, this.getY(), this.getX() + i + 1, this.getY() + this.getHeight(), Mth.hsvToArgb((float)((float)i / (float)this.getWidth()), (float)1.0f, (float)1.0f, (int)255));
        }
        int posX = Mth.floor((float)(this.state.get().hue() * (float)this.getWidth()));
        graphics.renderOutline(this.getX() + posX - 1, this.getY() - 1, 3, this.getHeight() + 2, -16777216);
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean bl) {
        if (event.input() != 0) {
            return false;
        }
        if (!this.isMouseOver(event.x(), event.y())) {
            return false;
        }
        float hue = Mth.clamp((float)((float)(event.x() - (double)this.getX()) / (float)this.getWidth()), (float)0.0f, (float)1.0f);
        this.state.set(this.state.get().withHue(hue));
        return true;
    }

    public boolean mouseDragged(@NotNull MouseButtonEvent event, double d, double e) {
        return this.mouseClicked(event, false);
    }
}

