/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.FileHandler;
import atomicstryker.ruins.common.RuinData;
import atomicstryker.ruins.common.RuinStats;
import atomicstryker.ruins.common.RuinTemplate;
import atomicstryker.ruins.common.RuinsMod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

class RuinGenerator {
    static final int WORLD_MIN_HEIGHT = -64;
    private static final String fileName = "RuinsPositionsFile.txt";
    private final FileHandler fileHandler;
    private final RuinStats stats;
    private final ConcurrentSkipListSet<RuinData> registeredRuins;
    private final File ruinsDataFile;
    private final File ruinsDataFileWriting;
    private int numTries = 0;
    private int LastNumTries = 0;
    private AtomicBoolean flushing;

    public RuinGenerator(FileHandler rh, Level world) {
        this.fileHandler = rh;
        this.stats = new RuinStats();
        this.registeredRuins = new ConcurrentSkipListSet();
        this.flushing = new AtomicBoolean(false);
        this.ruinsDataFile = new File(rh.saveFolder, fileName);
        this.ruinsDataFileWriting = new File(rh.saveFolder, "RuinsPositionsFile.txt_writing");
        new LoadThread().start();
    }

    void flushPosFile(String worldName) {
        if (this.registeredRuins.isEmpty() || worldName.equals("MpServer")) {
            return;
        }
        if (this.flushing.compareAndSet(false, true)) {
            new FlushThread().start();
        }
    }

    private void loadPosFile(File file) {
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new RuntimeException("Ruins crashed trying to access file " + String.valueOf(file));
            }
            int lineNumber = 1;
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = br.readLine();
            while (line != null) {
                if (!(line = line.trim()).startsWith("#") && !line.isEmpty()) {
                    try {
                        this.registeredRuins.add(new RuinData(line));
                    }
                    catch (Exception e) {
                        RuinsMod.LOGGER.error("Ruins positions file is invalid in line {}}, skipping...", (Object)lineNumber);
                    }
                }
                ++lineNumber;
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void generateNormal(Level world, RandomSource random, int xBase, int zBase) {
        for (int c = 0; c < this.fileHandler.triesPerChunkNormal; ++c) {
            this.createBuilding(world, random, xBase + random.nextInt(16), zBase + random.nextInt(16), false);
        }
    }

    void generateNether(Level world, RandomSource random, int xBase, int zBase) {
        for (int c = 0; c < this.fileHandler.triesPerChunkNether; ++c) {
            this.createBuilding(world, random, xBase + random.nextInt(16), zBase + random.nextInt(16), true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createBuilding(Level world, RandomSource random, int x, int z, boolean nether) {
        Integer i;
        int rotate = random.nextInt(4);
        String biomeID = ((ResourceKey)world.getBiome(new BlockPos(x, world.getSeaLevel(), z)).unwrapKey().get()).identifier().getPath();
        if (this.fileHandler.useGeneric(random, biomeID)) {
            biomeID = "generic";
        }
        i = (i = this.stats.biomes.get(biomeID)) != null ? Integer.valueOf(i + 1) : Integer.valueOf(1);
        this.stats.biomes.put(biomeID, i);
        RuinTemplate ruinTemplate = this.fileHandler.getTemplate(random, biomeID);
        if (ruinTemplate == null) {
            return;
        }
        ++this.numTries;
        int y = this.findSuitableY(world, ruinTemplate, x, z, nether);
        if (y > world.getMinY()) {
            if (!this.checkMinDistance(world, ruinTemplate, ruinTemplate.getRuinData(x, y, z, rotate))) {
                ++this.stats.minDistFails;
                return;
            }
            if ((y = ruinTemplate.checkArea(world, x, y, z, rotate)) < world.getMinY()) {
                ++this.stats.levelingFails;
                return;
            }
            int finalY = ruinTemplate.doBuild(world, random, x, y, z, rotate, false, false);
            if (finalY > world.getMinY()) {
                if (!this.fileHandler.disableLogging) {
                    RuinsMod.LOGGER.info("Creating ruin {} of Biome {} at [{}|{}|{}]\n", (Object)ruinTemplate.getName(), (Object)biomeID, (Object)x, (Object)y, (Object)z);
                }
                ++this.stats.numCreated;
                this.registeredRuins.add(ruinTemplate.getRuinData(x, y, z, rotate));
            }
        } else {
            ++this.stats.noSurfaceFails;
        }
        if (this.numTries > this.LastNumTries + 5000) {
            this.LastNumTries = this.numTries;
            this.printStats();
        }
    }

    private void printStats() {
        if (!this.fileHandler.disableLogging) {
            int total = this.stats.numCreated + this.stats.levelingFails;
            RuinsMod.LOGGER.info("Current Stats:");
            RuinsMod.LOGGER.info("    Total Tries:                 " + total);
            RuinsMod.LOGGER.info("    Number Created:              " + this.stats.numCreated);
            RuinsMod.LOGGER.info("    Min Dist fails:              " + this.stats.minDistFails);
            RuinsMod.LOGGER.info("    No Surface fails:            " + this.stats.noSurfaceFails);
            RuinsMod.LOGGER.info("    Leveling fails:              " + this.stats.levelingFails);
            Registry biomeRegistryLookup = RuinsMod.getInstance().getLastLoadedLevel().registryAccess().lookupOrThrow(Registries.BIOME);
            Set biomeSet = biomeRegistryLookup.listElements().collect(Collectors.toSet());
            for (Holder.Reference biomeReference : biomeSet) {
                Integer i = this.stats.biomes.get(biomeReference.getKey().identifier().getPath());
                if (i == null) continue;
                RuinsMod.LOGGER.info(biomeReference.getKey().identifier().getPath() + ": " + i + " Biome building attempts");
            }
            RuinsMod.LOGGER.info("Any-Biome: " + String.valueOf(this.stats.biomes.get("generic")) + " building attempts");
            RuinsMod.LOGGER.info("");
        }
    }

    private boolean checkMinDistance(Level world, RuinTemplate ruinTemplate, RuinData ruinData) {
        if (world.dimension().identifier().getPath().equals("overworld")) {
            BlockPos spawn = world.getLevelData().getRespawnData().pos();
            int min_distance = Math.max(this.fileHandler.anySpawnMinDistance, ruinTemplate.spawnMinDistance);
            if (ruinData.xMin - spawn.getX() < min_distance && spawn.getX() - ruinData.xMax < min_distance && ruinData.zMin - spawn.getZ() < min_distance && spawn.getZ() - ruinData.zMax < min_distance) {
                return false;
            }
            int max_distance = Math.min(this.fileHandler.anySpawnMaxDistance, ruinTemplate.spawnMaxDistance);
            if (ruinData.xMax - spawn.getX() > max_distance || spawn.getX() - ruinData.xMin > max_distance || ruinData.zMax - spawn.getZ() > max_distance || spawn.getZ() - ruinData.zMin > max_distance) {
                return false;
            }
        }
        int bbExtension = (int)(ruinTemplate.uniqueMinDistance == 0 ? this.fileHandler.templateInstancesMinDistance : (float)ruinTemplate.uniqueMinDistance);
        RuinData checkSelfMinDist = new RuinData(ruinData.xMin - bbExtension, ruinData.xMax + bbExtension, ruinData.yMin - bbExtension, ruinData.yMax + bbExtension, ruinData.zMin - bbExtension, ruinData.zMax + bbExtension, ruinData.name);
        bbExtension = (int)this.fileHandler.anyRuinsMinDistance;
        RuinData checkOtherMinDist = new RuinData(ruinData.xMin - bbExtension, ruinData.xMax + bbExtension, ruinData.yMin - bbExtension, ruinData.yMax + bbExtension, ruinData.zMin - bbExtension, ruinData.zMax + bbExtension, ruinData.name);
        for (RuinData r : this.registeredRuins) {
            boolean tooClose = r.name.equals(ruinData.name) ? checkSelfMinDist.intersectsWith(r) : checkOtherMinDist.intersectsWith(r);
            if (!tooClose) continue;
            return false;
        }
        return true;
    }

    private int findSuitableY(Level world, RuinTemplate r, int x, int z, boolean nether) {
        if (!nether) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int y = world.getMaxY() - 1; y > -64; --y) {
                pos.set(x, y, z);
                BlockState b = world.getBlockState((BlockPos)pos);
                if (b.is(Blocks.BEDROCK)) {
                    return world.getMinY() - 1;
                }
                if (r.isIgnoredBlock(b) || !r.isAcceptableSurface(world, b, (BlockPos)pos)) continue;
                return y + 1;
            }
            return world.getMinY() - 1;
        }
        if (x % 2 == 1 ^ z % 2 == 1) {
            for (int y = world.getMaxY() - 1; y > -64; --y) {
                BlockPos basePos = new BlockPos(x, y, z);
                BlockState b = world.getBlockState(basePos);
                if (b.is(Blocks.BEDROCK)) {
                    return world.getMinY() - 1;
                }
                if (!b.is(Blocks.AIR)) continue;
                while (y > -64) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!r.isIgnoredBlock(world.getBlockState(pos))) {
                        if (r.isAcceptableSurface(world, b, pos)) {
                            return y + 1;
                        }
                        return world.getMinY() - 1;
                    }
                    --y;
                }
            }
        } else {
            boolean accept = false;
            for (int y = 0; y < world.getMaxY(); ++y) {
                BlockPos pos = new BlockPos(x, y, z);
                BlockState b = world.getBlockState(pos);
                if (b.is(Blocks.BEDROCK)) {
                    return world.getMinY() - 1;
                }
                if (r.isIgnoredBlock(b)) {
                    return accept ? y : world.getMinY() - 1;
                }
                accept = r.isAcceptableSurface(world, b, pos);
            }
        }
        return world.getMinY() - 1;
    }

    private class LoadThread
    extends Thread {
        private LoadThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File file = RuinGenerator.this.ruinsDataFile;
            synchronized (file) {
                RuinGenerator.this.loadPosFile(RuinGenerator.this.ruinsDataFile);
            }
        }
    }

    private class FlushThread
    extends Thread {
        private FlushThread() {
        }

        @Override
        public void run() {
            try {
                this.doFlush();
            }
            finally {
                RuinGenerator.this.flushing.set(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFlush() {
            if (RuinGenerator.this.ruinsDataFileWriting.exists() && !RuinGenerator.this.ruinsDataFileWriting.delete()) {
                throw new RuntimeException("Ruins crashed trying to access file " + String.valueOf(RuinGenerator.this.ruinsDataFileWriting));
            }
            try {
                if (!RuinGenerator.this.ruinsDataFileWriting.createNewFile()) {
                    System.err.println("Ruins could not create new file: " + RuinGenerator.this.ruinsDataFileWriting.getAbsolutePath());
                }
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(RuinGenerator.this.ruinsDataFileWriting)));
                pw.println("# Ruins data management file. Below, you see all data accumulated by AtomicStrykers Ruins during the last run of this World.");
                pw.println("# Data is noted as follows: Each line stands for one successfull Ruin spawn. Data syntax is:");
                pw.println("# xMin yMin zMin xMax yMax zMax templateName");
                pw.println("# everything but the last value is an integer value. Template name equals the template file name.");
                pw.println("#");
                pw.println("# DO NOT EDIT THIS FILE UNLESS YOU ARE SURE OF WHAT YOU ARE DOING");
                pw.println("#");
                pw.println("# The primary function of this file is to lock areas you do not want Ruins spawning in. Put them here before worldgen.");
                pw.println("# It should also prevent Ruins re-spawning under any circumstances. Areas registered in here block any overlapping new Ruins.");
                pw.println("# Empty lines and those prefixed by '#' are ignored by the parser. Don't save notes in here, file gets wiped upon flushing.");
                pw.println("#");
                for (RuinData r : RuinGenerator.this.registeredRuins) {
                    pw.println(r.toString());
                }
                pw.flush();
                pw.close();
                File file = RuinGenerator.this.ruinsDataFile;
                synchronized (file) {
                    if (RuinGenerator.this.ruinsDataFile.exists() && !RuinGenerator.this.ruinsDataFile.delete()) {
                        throw new RuntimeException("Ruins crashed trying to access file " + String.valueOf(RuinGenerator.this.ruinsDataFileWriting));
                    }
                    if (!RuinGenerator.this.ruinsDataFileWriting.renameTo(RuinGenerator.this.ruinsDataFile)) {
                        throw new RuntimeException("Ruins crashed trying to access file " + String.valueOf(RuinGenerator.this.ruinsDataFileWriting));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

