/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.line;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import xaero.common.graphics.CustomRenderTypes;
import xaeroplus.Globals;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.DrawHelper;
import xaeroplus.feature.render.line.AbstractLineDrawFeature;
import xaeroplus.feature.render.line.Line;
import xaeroplus.feature.render.line.LinePreProcessor;
import xaeroplus.feature.render.line.MultiColorLineProvider;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class MultiColorLineDrawFeature
extends AbstractLineDrawFeature<Object2IntMap<Line>> {
    private final String id;
    private final MultiColorLineProvider lineProvider;

    public MultiColorLineDrawFeature(String id, MultiColorLineProvider lineProvider, int refreshIntervalMs) {
        super(refreshIntervalMs);
        this.id = id;
        this.lineProvider = lineProvider;
    }

    @Override
    public float lineWidth() {
        return this.lineProvider.lineWidthSupplier().getFloat();
    }

    @Override
    public Object2IntMap<Line> provideLinesInWindow(int windowX, int windowZ, int windowSize, ResourceKey<Level> dimension) {
        return this.lineProvider.lineSupplier().getLines(windowX, windowZ, windowSize, dimension);
    }

    @Override
    public Object2IntMap<Line> preProcessLines(Object2IntMap<Line> lines, int windowX, int windowZ, int windowSize) {
        if (lines.isEmpty()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap out = new Object2IntOpenHashMap(lines.size());
        int windowXMin = ChunkUtils.regionCoordToCoord(windowX - windowSize);
        int windowZMin = ChunkUtils.regionCoordToCoord(windowZ - windowSize);
        int windowXMax = ChunkUtils.regionCoordToCoord(windowX + windowSize);
        int windowZMax = ChunkUtils.regionCoordToCoord(windowZ + windowSize);
        ObjectIterator it = Object2IntMaps.fastIterator(lines);
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            Line line = (Line)entry.getKey();
            if (!line.lineClip(windowXMin, windowXMax, windowZMin, windowZMax)) continue;
            List<Line> newLines = LinePreProcessor.ensureLength(line);
            if (!newLines.isEmpty()) {
                for (Line newLine : newLines) {
                    out.put((Object)LinePreProcessor.ensureOrientation(newLine), entry.getIntValue());
                }
                continue;
            }
            out.put((Object)LinePreProcessor.ensureOrientation(line), entry.getIntValue());
        }
        return out;
    }

    @Override
    public Object2IntMap<Line> emptyLines() {
        return Object2IntMaps.emptyMap();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void render(DrawContext ctx) {
        this.preRender(ctx);
        BufferBuilder lineBuffer = ctx.renderTypeBuffers().getBuffer(CustomRenderTypes.MAP_LINES);
        float lineWidthScale = 16.0f * (float)Mth.clamp((double)((double)this.lineWidth() * ctx.fboScale()), (double)(0.1f * (ctx.worldmap() ? 1.0f : (float)Globals.minimapScaleMultiplier)), (double)1000.0);
        Object2IntMap lines = (Object2IntMap)this.getLines();
        ObjectIterator it = Object2IntMaps.fastIterator((Object2IntMap)lines);
        boolean hasLines = false;
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            Line line = (Line)entry.getKey();
            int color = this.lineProvider.colorFunction().getColor(line, entry.getIntValue());
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            float a = ColorHelper.getA(color);
            if (a == 0.0f) continue;
            int x1 = ctx.worldmap() ? line.x2() : line.x1();
            int z1 = ctx.worldmap() ? line.z2() : line.z1();
            int x2 = ctx.worldmap() ? line.x1() : line.x2();
            int z2 = ctx.worldmap() ? line.z1() : line.z2();
            DrawHelper.addColoredLineToExistingBuffer(ctx.matrixStack().last(), (VertexConsumer)lineBuffer, x1, z1, x2, z2, r, g, b, a, lineWidthScale);
            hasLines = true;
        }
        if (hasLines) {
            ctx.renderTypeBuffers().endBatch(CustomRenderTypes.MAP_LINES);
        }
    }
}

