/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.fixes.BiomeFix;
import net.minecraft.util.datafix.fixes.CavesAndCliffsRenames;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.feature.highlights.SavableHighlightCacheInstance;
import xaeroplus.feature.render.DrawFeatureFactory;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.shadow.kaptainwutax.biomeutils.biome.Biome;
import xaeroplus.shadow.kaptainwutax.biomeutils.source.OverworldBiomeSource;
import xaeroplus.shadow.kaptainwutax.mcutils.version.MCVersion;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class OldBiomes
extends Module {
    public final SavableHighlightCacheInstance oldBiomesCache = new SavableHighlightCacheInstance("XaeroPlusOldBiomes");
    private static final long seed = -4172144997902289642L;
    private static final MCVersion mcVersion = MCVersion.v1_12_2;
    private final OverworldBiomeSource biomeSource = new OverworldBiomeSource(mcVersion, -4172144997902289642L);
    private int oldBiomesColor = ColorHelper.getColor(0, 255, 0, 100);

    @Override
    public void onEnable() {
        Globals.drawManager.registry().register(DrawFeatureFactory.chunkHighlights("OldBiomes", this::getHighlightsState, this::getOldBiomesColor, 250));
        this.oldBiomesCache.onEnable();
        try {
            this.searchAllLoadedChunks();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error searching all loaded chunks", (Throwable)e);
        }
    }

    @Override
    public void onDisable() {
        this.oldBiomesCache.onDisable();
        Globals.drawManager.registry().unregister("OldBiomes");
    }

    @EventHandler
    public void onChunkDataEvent(ChunkDataEvent event) {
        if (event.seenChunk()) {
            return;
        }
        try {
            if (event.chunk().getLevel().dimension() != Level.OVERWORLD) {
                return;
            }
            this.searchBiome((ChunkAccess)event.chunk());
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error checking for OldBiome at chunk pos: [{}, {}]", new Object[]{event.chunk().getPos().x, event.chunk().getPos().z, e});
        }
    }

    private void searchBiome(ChunkAccess chunk) {
        int blockPosZ;
        int blockPosY;
        int x = chunk.getPos().x;
        int z = chunk.getPos().z;
        if (this.oldBiomesCache.get().isHighlighted(x, z, ChunkUtils.getActualDimension())) {
            return;
        }
        int blockPosX = ChunkUtils.chunkCoordToCoord(x) + 1;
        Biome biome = this.biomeSource.getBiome(blockPosX, blockPosY = 50, blockPosZ = ChunkUtils.chunkCoordToCoord(z) + 1);
        if (biome == null) {
            XaeroPlus.LOGGER.error("Null biome returned from source at: {} {} {}", new Object[]{blockPosX, blockPosY, blockPosZ});
            return;
        }
        String oldBiomeName = biome.getName();
        String oldBiomeFixup = this.fixupOldBiome(oldBiomeName);
        int sectionIndex = chunk.getSectionIndex(blockPosY);
        AtomicBoolean containsBiome = new AtomicBoolean(false);
        PalettedContainerRO palettedContainerR0 = chunk.getSection(sectionIndex).getBiomes();
        if (palettedContainerR0 instanceof PalettedContainer) {
            PalettedContainer palettedContainer = (PalettedContainer)palettedContainerR0;
            palettedContainer.data.storage().getAll(i -> {
                if (containsBiome.get()) {
                    return;
                }
                Holder holder = (Holder)palettedContainer.data.palette().valueFor(i);
                boolean match = holder.unwrapKey().map(ResourceKey::identifier).map(Identifier::getPath).filter(path -> path.equals(oldBiomeFixup)).isPresent();
                containsBiome.set(match);
            });
        }
        if (containsBiome.get()) {
            this.oldBiomesCache.get().addHighlight(x, z);
        }
    }

    private String fixupOldBiome(String oldBiome) {
        Object oldBiomeFixupNamespaced = "minecraft:" + oldBiome;
        oldBiomeFixupNamespaced = (String)((Object)BiomeFix.BIOMES.getOrDefault(oldBiomeFixupNamespaced, oldBiomeFixupNamespaced));
        oldBiomeFixupNamespaced = (String)CavesAndCliffsRenames.RENAMES.getOrDefault(oldBiomeFixupNamespaced, oldBiomeFixupNamespaced);
        return ((String)oldBiomeFixupNamespaced).split("minecraft:")[1];
    }

    private void searchAllLoadedChunks() {
        if (this.mc.level == null || ChunkUtils.getActualDimension() != Level.OVERWORLD) {
            return;
        }
        int renderDist = (Integer)this.mc.options.renderDistance().get();
        int xMin = ChunkUtils.actualPlayerChunkX() - renderDist;
        int xMax = ChunkUtils.actualPlayerChunkX() + renderDist;
        int zMin = ChunkUtils.actualPlayerChunkZ() - renderDist;
        int zMax = ChunkUtils.actualPlayerChunkZ() + renderDist;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                LevelChunk chunk = this.mc.level.getChunkSource().getChunk(x, z, false);
                if (chunk instanceof EmptyLevelChunk || chunk == null) continue;
                this.searchBiome((ChunkAccess)chunk);
            }
        }
    }

    public int getOldBiomesColor() {
        return this.oldBiomesColor;
    }

    public Long2LongMap getHighlightsState(ResourceKey<Level> dimension) {
        return this.oldBiomesCache.get().getCacheMap(dimension);
    }

    public void setDiskCache(boolean b) {
        this.oldBiomesCache.setDiskCache(b, this.isEnabled());
    }

    public void setAlpha(double b) {
        this.oldBiomesColor = ColorHelper.getColorWithAlpha(this.oldBiomesColor, (int)b);
    }

    public void setRgbColor(int color) {
        this.oldBiomesColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.oldBiomesAlphaSetting.getAsInt());
    }
}

