/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import it.unimi.dsi.fastutil.objects.ReferenceSet;
import net.minecraft.util.BitStorage;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;

public class ChunkScanner {
    public static boolean chunkContainsBlocks(ChunkAccess chunk, ReferenceSet<Block> filter, int yLevelMin) {
        LevelChunkSection[] sectionArray = chunk.getSections();
        for (int i = 0; i < sectionArray.length; ++i) {
            int sectionBottomY = chunk.getMinY() + i * 16;
            if (yLevelMin > sectionBottomY + 15) continue;
            int yScanStart = yLevelMin > sectionBottomY ? yLevelMin % 16 : 0;
            LevelChunkSection section = sectionArray[i];
            if (section == null || section.hasOnlyAir()) continue;
            PalettedContainer blockStateContainer = section.getStates();
            PalettedContainer.Data paletteData = blockStateContainer.data;
            BitStorage array = paletteData.storage();
            if (array == null || !blockStateContainer.maybeHas(bs -> filter.contains((Object)bs.getBlock()))) continue;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = yScanStart; y < 16; ++y) {
                        BlockState state = (BlockState)blockStateContainer.get(x, y, z);
                        if (!filter.contains((Object)state.getBlock())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void chunkScanBlockstatePredicate(ChunkAccess chunk, ReferenceSet<Block> filter, BlockStateScanPredicate statePredicate, int yLevelMin) {
        LevelChunkSection[] sectionArray = chunk.getSections();
        for (int i = 0; i < sectionArray.length; ++i) {
            int sectionBottomY = chunk.getMinY() + i * 16;
            if (yLevelMin > sectionBottomY + 15) continue;
            int yScanStart = yLevelMin > sectionBottomY ? yLevelMin % 16 : 0;
            LevelChunkSection section = sectionArray[i];
            if (section == null || section.hasOnlyAir()) continue;
            PalettedContainer blockStateContainer = section.getStates();
            PalettedContainer.Data paletteData = blockStateContainer.data;
            BitStorage array = paletteData.storage();
            if (array == null || !blockStateContainer.maybeHas(bs -> filter.contains((Object)bs.getBlock()))) continue;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = yScanStart; y < 16; ++y) {
                        BlockState state = (BlockState)blockStateContainer.get(x, y, z);
                        if (!statePredicate.test(chunk, state, x, i * 16 + y, z)) continue;
                        return;
                    }
                }
            }
        }
    }

    public static interface BlockStateScanPredicate {
        public boolean test(ChunkAccess var1, BlockState var2, int var3, int var4, int var5);
    }
}

