/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking;

import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.SpawnEntityPacket;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ClientSpawnEntityPacket {
    public static void register() {
        NetworkManager.registerReceiver(NetworkManager.s2c(), SpawnEntityPacket.PACKET_TYPE, SpawnEntityPacket.PACKET_CODEC, ClientSpawnEntityPacket::receive);
    }

    private static void receive(SpawnEntityPacket.PacketPayload payload, NetworkManager.PacketContext context) {
        context.queue(() -> {
            if (Minecraft.getInstance().level == null) {
                throw new IllegalStateException("Client world is null!");
            }
            Entity entity = payload.entityType().create((Level)Minecraft.getInstance().level, EntitySpawnReason.LOAD);
            if (entity == null) {
                throw new IllegalStateException("Created entity is null!");
            }
            entity.setUUID(payload.uuid());
            entity.setId(payload.id());
            entity.syncPacketPositionCodec(payload.x(), payload.y(), payload.z());
            entity.snapTo(payload.x(), payload.y(), payload.z(), payload.xRot(), payload.yRot());
            entity.setYHeadRot(payload.yHeadRot());
            entity.setYBodyRot(payload.yHeadRot());
            if (entity instanceof EntitySpawnExtension) {
                EntitySpawnExtension ext = (EntitySpawnExtension)entity;
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])payload.data()), context.registryAccess());
                ext.loadAdditionalSpawnData((FriendlyByteBuf)buf);
                buf.release();
            }
            Minecraft.getInstance().level.addEntity(entity);
            entity.lerpMotion(new Vec3(payload.deltaX(), payload.deltaY(), payload.deltaZ()));
        });
    }
}

