/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.Nullable;

public interface Registrar<T>
extends Iterable<T> {
    public RegistrySupplier<T> delegate(Identifier var1);

    default public <R extends T> RegistrySupplier<R> wrap(R obj) {
        Identifier id = this.getId(obj);
        if (id == null) {
            throw new IllegalArgumentException("Cannot wrap an object without an id: " + String.valueOf(obj));
        }
        return this.delegate(id);
    }

    public <E extends T> RegistrySupplier<E> register(Identifier var1, Supplier<E> var2);

    @Nullable
    public Identifier getId(T var1);

    public int getRawId(T var1);

    public Optional<ResourceKey<T>> getKey(T var1);

    @Nullable
    public T get(Identifier var1);

    @Nullable
    public T byRawId(int var1);

    public boolean contains(Identifier var1);

    public boolean containsValue(T var1);

    public Set<Identifier> getIds();

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet();

    public ResourceKey<? extends Registry<T>> key();

    @Nullable
    public Holder<T> getHolder(ResourceKey<T> var1);

    @Nullable
    default public Holder<T> getHolder(Identifier id) {
        return this.getHolder(ResourceKey.create(this.key(), (Identifier)id));
    }

    default public <R extends T> void listen(RegistrySupplier<R> supplier, Consumer<R> callback) {
        this.listen(supplier.getId(), (T obj) -> callback.accept(obj));
    }

    public void listen(Identifier var1, Consumer<T> var2);
}

