/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lol.bai.badpackets.api.PacketReadyCallback;
import lol.bai.badpackets.api.PacketReceiver;
import lol.bai.badpackets.api.config.ConfigTaskExecutor;
import lol.bai.badpackets.api.config.ServerConfigContext;
import lol.bai.badpackets.impl.handler.AbstractPacketHandler;
import lol.bai.badpackets.impl.platform.PlatformProxy;
import lol.bai.badpackets.impl.registry.CallbackRegistry;
import lol.bai.badpackets.impl.registry.ChannelRegistry;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundPingPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.util.thread.BlockableEventLoop;
import org.jetbrains.annotations.NotNull;

public class ServerConfigPacketHandler
extends AbstractPacketHandler<ServerConfigContext, FriendlyByteBuf>
implements ServerConfigContext {
    public static final Map<Identifier, CustomTask> CUSTOM_TASKS = new HashMap<Identifier, CustomTask>();
    private final MinecraftServer server;
    private final ServerConfigurationPacketListenerImpl listener;

    public ServerConfigPacketHandler(MinecraftServer server, ServerConfigurationPacketListenerImpl listener, Connection connection) {
        super("ServerConfigPacketHandler for " + listener.getOwner().name(), ChannelRegistry.CONFIG_C2S, ClientboundCustomPayloadPacket::new, (BlockableEventLoop<?>)server, connection);
        this.server = server;
        this.listener = listener;
    }

    public static void registerTask(Identifier id, ConfigTaskExecutor executor) {
        CUSTOM_TASKS.put(id, new CustomTask(id, executor));
    }

    public CallbackTask createCallbackTask() {
        return new CallbackTask();
    }

    @Override
    protected Packet<?> createVanillaRegisterPacket(Set<Identifier> channels, Consumer<FriendlyByteBuf> buf) {
        return PlatformProxy.INSTANCE.createVanillaRegisterConfigS2CPacket(channels, buf);
    }

    @Override
    protected void onInitialChannelSyncPacketReceived() {
        for (PacketReadyCallback<ServerConfigContext> callback : CallbackRegistry.SERVER_READY_CONFIG) {
            callback.onReady(this);
        }
        ((TaskFinisher)this.listener).badpackets_finishTask(CallbackTask.TYPE);
    }

    @Override
    protected void receiveUnsafe(PacketReceiver<ServerConfigContext, CustomPacketPayload> receiver, CustomPacketPayload payload) {
        receiver.receive(this, payload);
    }

    @Override
    public MinecraftServer server() {
        return this.server;
    }

    @Override
    public ServerConfigurationPacketListenerImpl handler() {
        return this.listener;
    }

    @Override
    public void finishTask(Identifier taskId) {
        ((TaskFinisher)this.listener).badpackets_finishTask(ServerConfigPacketHandler.CUSTOM_TASKS.get((Object)taskId).type);
    }

    public static class CustomTask
    implements ConfigurationTask {
        private final ConfigurationTask.Type type;
        private final ConfigTaskExecutor executor;
        private ServerConfigPacketHandler handler;

        public CustomTask(Identifier id, ConfigTaskExecutor executor) {
            this.type = new ConfigurationTask.Type(id.toString());
            this.executor = executor;
        }

        public void setHandler(ServerConfigPacketHandler handler) {
            this.handler = handler;
        }

        public void start(@NotNull Consumer<Packet<?>> consumer) {
            if (!this.executor.runTask(this.handler)) {
                ((TaskFinisher)this.handler.listener).badpackets_finishTask(this.type);
            }
        }

        @NotNull
        public ConfigurationTask.Type type() {
            return this.type;
        }
    }

    public class CallbackTask
    implements ConfigurationTask {
        public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type("badpackets");

        public void start(@NotNull Consumer<Packet<?>> sender) {
            ServerConfigPacketHandler.this.sendInitialChannelSyncPacket();
            sender.accept((Packet<?>)new ClientboundPingPacket(-1160460543));
        }

        @NotNull
        public ConfigurationTask.Type type() {
            return TYPE;
        }
    }

    public static interface TaskFinisher {
        public void badpackets_finishTask(ConfigurationTask.Type var1);
    }
}

