/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.handler;

import java.util.Set;
import java.util.function.Consumer;
import lol.bai.badpackets.api.PacketReadyCallback;
import lol.bai.badpackets.api.PacketReceiver;
import lol.bai.badpackets.api.play.ServerPlayContext;
import lol.bai.badpackets.impl.handler.AbstractPacketHandler;
import lol.bai.badpackets.impl.handler.PacketHandlerHolder;
import lol.bai.badpackets.impl.platform.PlatformProxy;
import lol.bai.badpackets.impl.registry.CallbackRegistry;
import lol.bai.badpackets.impl.registry.ChannelRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.thread.BlockableEventLoop;

public class ServerPlayPacketHandler
extends AbstractPacketHandler<ServerPlayContext, RegistryFriendlyByteBuf>
implements ServerPlayContext {
    private final MinecraftServer server;
    private final ServerGamePacketListenerImpl handler;

    public ServerPlayPacketHandler(MinecraftServer server, ServerGamePacketListenerImpl handler, Connection connection) {
        super("ServerPlayPacketHandler for " + handler.getPlayer().getScoreboardName(), ChannelRegistry.PLAY_C2S, ClientboundCustomPayloadPacket::new, (BlockableEventLoop<?>)server, connection);
        this.server = server;
        this.handler = handler;
    }

    public static ServerPlayPacketHandler get(ServerPlayer player) {
        return (ServerPlayPacketHandler)((PacketHandlerHolder)player.connection).badpackets_handler();
    }

    @Override
    protected Packet<?> createVanillaRegisterPacket(Set<Identifier> channels, Consumer<RegistryFriendlyByteBuf> buf) {
        return PlatformProxy.INSTANCE.createVanillaRegisterPlayS2CPacket((RegistryAccess)this.server.registryAccess(), channels, buf);
    }

    @Override
    protected void onInitialChannelSyncPacketReceived() {
        for (PacketReadyCallback<ServerPlayContext> callback : CallbackRegistry.SERVER_PLAY) {
            callback.onReady(this);
        }
    }

    @Override
    protected void receiveUnsafe(PacketReceiver<ServerPlayContext, CustomPacketPayload> receiver, CustomPacketPayload payload) {
        receiver.receive(this, payload);
    }

    @Override
    public MinecraftServer server() {
        return this.server;
    }

    @Override
    public ServerPlayer player() {
        return this.handler.player;
    }

    @Override
    public ServerGamePacketListenerImpl handler() {
        return this.handler;
    }
}

