/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client;

import baguchi.bagus_lib.BagusConfigs;
import baguchi.bagus_lib.BagusLib;
import baguchi.bagus_lib.api.IBaguAnimate;
import baguchi.bagus_lib.client.event.BagusModelEvent;
import baguchi.bagus_lib.client.game.WaterMelonScreen;
import baguchi.bagus_lib.client.render.book.Book;
import baguchi.bagus_lib.client.render.book.component.BookComponentDefinition;
import baguchi.bagus_lib.client.render.book.component.DialogBookComponent;
import baguchi.bagus_lib.client.render.book.component.DisplayBookComponent;
import baguchi.bagus_lib.client.render.screen.BookScreen;
import baguchi.bagus_lib.util.DialogHandler;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Calendar;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.player.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.joml.Quaternionfc;

@EventBusSubscriber(value={Dist.CLIENT}, modid="bagus_lib")
public class ClientEventHandler {
    private static boolean initDate = false;
    private static boolean aprilFools = false;

    @SubscribeEvent
    public static void screenRender(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            if (ClientEventHandler.isAprilFools()) {
                int l = titleScreen.height / 4 + 28;
                event.addListener((GuiEventListener)Button.builder((Component)Component.translatable((String)"bagus_lib.watermelon"), p_280785_ -> Minecraft.getInstance().setScreen((Screen)new WaterMelonScreen((Component)Component.empty()))).bounds(titleScreen.width / 2 + 100, l + 4, 100, 20).build());
            }
        }
    }

    public static void handleOpenPageTest(Player player) {
        if (player.level().isClientSide() && player == Minecraft.getInstance().player) {
            DisplayBookComponent title = new DisplayBookComponent(121, 158).imageDisplay(BagusLib.prefix("textures/gui/sprites/test.png"), 4, 10, 100, 100).textDisplay((Component)Component.literal((String)"test"), 52, 115, 1.2f);
            DialogBookComponent test2 = new DialogBookComponent((Component)Component.literal((String)"test2. testetteafrafdadadsadadasad"), false, 100, 158);
            Book book = new Book(Lists.newArrayList((Object[])new BookComponentDefinition[]{new BookComponentDefinition(title, BagusLib.prefix("title"), 10, 10, 10, 10), new BookComponentDefinition(test2, BagusLib.prefix("test2"), 10, 10, 10, 10)}), 256, 182, 23, 13, 12, 27, BagusLib.prefix("textures/gui/screen/book/book.png"), BagusLib.prefix("textures/gui/screen/book/book_back.png"), BagusLib.prefix("textures/gui/screen/book/book_back.png"), Identifier.withDefaultNamespace((String)"textures/gui/sprites/widget/page_backward.png"), Identifier.withDefaultNamespace((String)"textures/gui/sprites/widget/page_forward.png"));
            Minecraft.getInstance().setScreen((Screen)new BookScreen(book));
        }
    }

    public static boolean isAprilFools() {
        if (!initDate) {
            initDate = true;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            aprilFools = calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
        }
        return aprilFools && (Boolean)BagusConfigs.COMMON.aprilFool.get() != false || (Boolean)BagusConfigs.COMMON.alwayAplilFool.get() != false;
    }

    @SubscribeEvent
    public static void clientLoggOut(PlayerEvent.PlayerLoggedOutEvent event) {
        DialogHandler.INSTANCE.removeAllDialogType();
    }

    @SubscribeEvent
    public static void clientRespawn(PlayerEvent.PlayerRespawnEvent event) {
        DialogHandler.INSTANCE.removeAllDialogType();
    }

    @SubscribeEvent
    public static void animationArmEvent(RenderHandEvent event) {
        IBaguAnimate baguAnimate;
        boolean playFlag;
        LocalPlayer abstractClientPlayer = Minecraft.getInstance().player;
        AvatarRenderer playerrenderer = (AvatarRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)abstractClientPlayer);
        EntityModel entityModel = playerrenderer.getModel();
        if (abstractClientPlayer instanceof IBaguAnimate && (playFlag = (baguAnimate = (IBaguAnimate)abstractClientPlayer).getBaguController().hasPlayingAnimation())) {
            TickRateManager tickratemanager = Minecraft.getInstance().level.tickRateManager();
            AvatarRenderState playerRenderState = playerrenderer.createRenderState();
            playerrenderer.extractRenderState((Avatar)abstractClientPlayer, playerRenderState, Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(!tickratemanager.isEntityFrozen((Entity)abstractClientPlayer)));
            ClientEventHandler.renderArmWithItem((AbstractClientPlayer)abstractClientPlayer, event.getHand(), event.getSwingProgress(), event.getItemStack(), event.getEquipProgress(), event.getPoseStack(), event.getSubmitNodeCollector(), playerRenderState, event.getPackedLight(), entityModel);
            event.setCanceled(true);
        }
    }

    private static void renderArmWithItem(AbstractClientPlayer abstractClientPlayer, InteractionHand interactionHand, float swingProgress, ItemStack stack, float equipProgress, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, AvatarRenderState avatarRenderState, int light, EntityModel entityModel) {
        if (!abstractClientPlayer.isScoping()) {
            boolean flag = interactionHand == InteractionHand.MAIN_HAND;
            HumanoidArm humanoidarm = flag ? abstractClientPlayer.getMainArm() : abstractClientPlayer.getMainArm().getOpposite();
            boolean flag2 = humanoidarm == HumanoidArm.RIGHT;
            poseStack.pushPose();
            if (!abstractClientPlayer.isInvisible()) {
                boolean flag3;
                poseStack.pushPose();
                ClientEventHandler.renderPlayerArm(poseStack, submitNodeCollector, avatarRenderState, light, equipProgress, swingProgress, humanoidarm, entityModel);
                boolean bl = flag3 = humanoidarm == HumanoidArm.LEFT;
                if (entityModel instanceof PlayerModel) {
                    PlayerModel playerModel = (PlayerModel)entityModel;
                    playerModel.translateToHand(avatarRenderState, humanoidarm, poseStack);
                    poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                    poseStack.translate((float)(flag3 ? -1 : 1) / 16.0f, 0.125f, -0.625f);
                }
                ClientEventHandler.renderItem((LivingEntity)abstractClientPlayer, stack, flag3 ? ItemDisplayContext.THIRD_PERSON_LEFT_HAND : ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, poseStack, submitNodeCollector, light);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }

    private static void renderItem(LivingEntity livingEntity, ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int light) {
        if (!stack.isEmpty()) {
            Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderItem(livingEntity, stack, itemDisplayContext, poseStack, submitNodeCollector, light);
        }
    }

    private static void renderPlayerArm(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, AvatarRenderState avatarRenderState, int light, float equipProgress, float swingProgress, HumanoidArm humanoidArm, EntityModel entityModel) {
        boolean flag = humanoidArm != HumanoidArm.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = Mth.sqrt((float)swingProgress);
        float f2 = -0.3f * Mth.sin((double)(f1 * (float)Math.PI));
        float f3 = 0.4f * Mth.sin((double)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * Mth.sin((double)(swingProgress * (float)Math.PI));
        poseStack.translate(f * (f2 + 0.64000005f), f3 + -0.6f + equipProgress * -0.6f, f4 + -0.71999997f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f * 45.0f));
        float f5 = Mth.sin((double)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = Mth.sin((double)(f1 * (float)Math.PI));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f * f6 * 70.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f * f5 * -20.0f));
        LocalPlayer abstractclientplayer = Minecraft.getInstance().player;
        poseStack.translate(f * -1.0f, 3.6f, 3.5f);
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f * 120.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(200.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f * -135.0f));
        poseStack.translate(f * 5.6f, 0.0f, 0.0f);
        Identifier resourcelocation = abstractclientplayer.getSkin().body().texturePath();
        if (flag) {
            ClientEventHandler.renderRightHand(poseStack, submitNodeCollector, light, resourcelocation, abstractclientplayer.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE), (AbstractClientPlayer)abstractclientplayer, avatarRenderState, entityModel);
        } else {
            ClientEventHandler.renderLeftHand(poseStack, submitNodeCollector, light, resourcelocation, abstractclientplayer.isModelPartShown(PlayerModelPart.LEFT_SLEEVE), (AbstractClientPlayer)abstractclientplayer, avatarRenderState, entityModel);
        }
    }

    public static void renderRightHand(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int light, Identifier resourceLocation, boolean partShown, AbstractClientPlayer player, AvatarRenderState avatarRenderState, EntityModel entityModel) {
        if (!ClientHooks.renderSpecificFirstPersonArm((PoseStack)poseStack, (SubmitNodeCollector)submitNodeCollector, (int)light, (AbstractClientPlayer)player, (HumanoidArm)HumanoidArm.RIGHT) && entityModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)entityModel;
            ClientEventHandler.renderHand(poseStack, submitNodeCollector, light, resourceLocation, playerModel.rightArm, partShown, avatarRenderState, playerModel);
        }
    }

    public static void renderLeftHand(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int light, Identifier resourceLocation, boolean partShown, AbstractClientPlayer player, AvatarRenderState avatarRenderState, EntityModel entityModel) {
        if (!ClientHooks.renderSpecificFirstPersonArm((PoseStack)poseStack, (SubmitNodeCollector)submitNodeCollector, (int)light, (AbstractClientPlayer)player, (HumanoidArm)HumanoidArm.LEFT) && entityModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)entityModel;
            ClientEventHandler.renderHand(poseStack, submitNodeCollector, light, resourceLocation, playerModel.leftArm, partShown, avatarRenderState, playerModel);
        }
    }

    private static void renderHand(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int p_117778_, Identifier resourceLocation, ModelPart modelPart, boolean modelShown, AvatarRenderState avatarRenderState, PlayerModel playermodel) {
        modelPart.resetPose();
        modelPart.visible = true;
        playermodel.leftSleeve.visible = modelShown;
        playermodel.rightSleeve.visible = modelShown;
        LocalPlayer abstractClientPlayer = Minecraft.getInstance().player;
        if (abstractClientPlayer != null) {
            AvatarRenderer playerrenderer = (AvatarRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)abstractClientPlayer);
            EntityModel entityModel = playerrenderer.getModel();
            if (abstractClientPlayer instanceof IBaguAnimate) {
                IBaguAnimate baguAnimate = (IBaguAnimate)abstractClientPlayer;
                BagusModelEvent.PostAnimate event2 = new BagusModelEvent.PostAnimate((LivingEntityRenderState)avatarRenderState, entityModel);
                NeoForge.EVENT_BUS.post((Event)event2);
            }
            submitNodeCollector.submitModelPart(modelPart, poseStack, RenderTypes.entityTranslucent((Identifier)resourceLocation), avatarRenderState.lightCoords, OverlayTexture.NO_OVERLAY, null);
        }
    }
}

