/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class JigsawHelper {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (Identifier)Identifier.fromNamespaceAndPath((String)"minecraft", (String)"empty"));

    public static void registerJigsaw(MinecraftServer server, Identifier poolLocation, Identifier nbtLocation, int weight) {
        RegistryAccess.Frozen manager = server.registryAccess();
        Registry templatePoolRegistry = manager.lookupOrThrow(Registries.TEMPLATE_POOL);
        Registry processorListRegistry = manager.lookupOrThrow(Registries.PROCESSOR_LIST);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.getValue(poolLocation);
        if (pool == null) {
            return;
        }
        ObjectArrayList elements = pool.templates;
        Holder.Reference processorListHolder = processorListRegistry.getOrThrow(EMPTY_PROCESSOR_LIST_KEY);
        StructurePoolElement element = (StructurePoolElement)SinglePoolElement.legacy((String)nbtLocation.toString(), (Holder)processorListHolder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            elements.add((Object)element);
        }
        ArrayList elementCounts = new ArrayList(pool.rawTemplates);
        elements.addAll((ObjectList)pool.templates);
        elementCounts.addAll(pool.rawTemplates);
        pool.templates = elements;
        pool.rawTemplates = elementCounts;
    }
}

