/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.generators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.formations.generators.FormationsLootTableGenerator;
import com.supermartijn642.formations.generators.FormationsStructureSetGenerator;
import com.supermartijn642.formations.generators.StructureConfiguration;
import com.supermartijn642.formations.generators.StructureConfigurator;
import com.supermartijn642.formations.generators.TemplatePoolGenerator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.Identifier;

public final class StructureResourceGenerators {
    private final String modid;
    private final Map<String, StructureConfigurator> structures = new LinkedHashMap<String, StructureConfigurator>();
    private boolean registered = false;

    public StructureResourceGenerators(String modid) {
        this.modid = modid;
    }

    public void register() {
        if (this.registered) {
            throw new IllegalStateException("Registration has already completed!");
        }
        this.registered = true;
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)this.modid);
        final List<StructureConfiguration> properties = this.structures.values().stream().map(structure -> {
            StructureConfiguration structureConfiguration = StructureConfiguration.create(this.modid, structure.name);
            structure.configureStructure(structureConfiguration);
            return structureConfiguration;
        }).toList();
        handler.addGenerator(cache -> new TemplatePoolGenerator(this.modid, (ResourceCache)cache){

            public void generate() {
                StructureResourceGenerators.this.structures.values().forEach(structure -> structure.createTemplatePools(this));
            }
        });
        handler.addGenerator(cache -> new FormationsLootTableGenerator(this.modid, (ResourceCache)cache){

            public void generate() {
                StructureResourceGenerators.this.structures.values().forEach(structure -> structure.createLootTables(this));
            }
        });
        handler.addGenerator(cache -> new ResourceGenerator(this, this.modid, (ResourceCache)cache){
            final List<Pair<String, JsonObject>> data;
            {
                super(modid, cache);
                this.data = new ArrayList<Pair<String, JsonObject>>();
            }

            public void generate() {
                properties.forEach(structure -> {
                    JsonArray entries = new JsonArray();
                    structure.biomeTags.forEach(tag -> {
                        if (tag.getNamespace().equals("minecraft")) {
                            entries.add("#" + String.valueOf(tag));
                        } else {
                            JsonObject object = new JsonObject();
                            object.addProperty("id", "#" + String.valueOf(tag));
                            object.addProperty("required", Boolean.valueOf(false));
                            entries.add((JsonElement)object);
                        }
                    });
                    structure.biomes.forEach(biome -> {
                        if (biome.getNamespace().equals("minecraft")) {
                            entries.add(biome.toString());
                        } else {
                            JsonObject object = new JsonObject();
                            object.addProperty("id", biome.toString());
                            object.addProperty("required", Boolean.valueOf(false));
                            entries.add((JsonElement)object);
                        }
                    });
                    JsonObject json = new JsonObject();
                    json.add("values", (JsonElement)entries);
                    this.data.add((Pair<String, JsonObject>)Pair.of((Object)structure.identifier, (Object)json));
                    this.cache.trackToBeGeneratedResource(ResourceType.DATA, this.modid, "tags/worldgen/biome/has_structure", structure.identifier, ".json");
                });
            }

            public void save() {
                this.data.forEach(pair -> this.cache.saveJsonResource(ResourceType.DATA, (JsonObject)pair.right(), this.modid, "tags/worldgen/biome/has_structure", (String)pair.left()));
            }

            public String getName() {
                return this.modName + " Biome Tag Generator";
            }
        });
        handler.addGenerator(cache -> new ResourceGenerator(this, this.modid, (ResourceCache)cache){
            final List<Pair<String, JsonObject>> data;
            {
                super(modid, cache);
                this.data = new ArrayList<Pair<String, JsonObject>>();
            }

            public void generate() {
                properties.forEach(structure -> {
                    JsonObject json = new JsonObject();
                    structure.typeProperties.toJson(json);
                    json.addProperty("biomes", "#" + this.modid + ":has_structure/" + structure.identifier);
                    json.addProperty("step", structure.generationStep.getSerializedName());
                    json.addProperty("terrain_adaptation", structure.terrainAdjustment.getSerializedName());
                    json.add("spawn_overrides", (JsonElement)new JsonObject());
                    this.data.add((Pair<String, JsonObject>)Pair.of((Object)structure.identifier, (Object)json));
                });
            }

            public void save() {
                this.data.forEach(pair -> this.cache.saveJsonResource(ResourceType.DATA, (JsonObject)pair.right(), this.modid, "worldgen/structure", (String)pair.left()));
            }

            public String getName() {
                return this.modName + " Structure Generator";
            }
        });
        handler.addGenerator(cache -> new FormationsStructureSetGenerator(this, this.modid, (ResourceCache)cache){

            public void generate() {
                properties.forEach(structure -> this.addStructure(structure.structureSet, Identifier.fromNamespaceAndPath((String)this.modid, (String)structure.identifier), structure.weight));
            }
        });
    }

    public void addStructure(StructureConfigurator configurer) {
        if (this.registered) {
            throw new IllegalStateException("Cannot add structures after registration has completed!");
        }
        StructureConfigurator previous = this.structures.put(configurer.identifier, configurer);
        if (previous != null) {
            throw new IllegalStateException("Duplicate structure with name '" + configurer.name + "'!");
        }
    }
}

