/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pbr.texture;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.mixin.texture.SpriteContentsAnimatedTextureAccessor;
import net.irisshaders.iris.mixin.texture.SpriteContentsFrameInfoAccessor;
import net.irisshaders.iris.mixin.texture.SpriteContentsTickerAccessor;
import net.irisshaders.iris.pbr.loader.AtlasPBRLoader;
import net.irisshaders.iris.pbr.texture.PBRAtlasHolder;
import net.irisshaders.iris.pbr.texture.PBRDumpable;
import net.irisshaders.iris.pbr.texture.PBRType;
import net.irisshaders.iris.pbr.texture.TextureAtlasExtension;
import net.irisshaders.iris.pbr.util.TextureManipulationUtil;
import net.irisshaders.iris.platform.IrisPlatformHelpers;
import net.minecraft.SharedConstants;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public class PBRAtlasTexture
extends AbstractTexture
implements PBRDumpable {
    protected final TextureAtlas atlasTexture;
    protected final PBRType type;
    protected final Identifier location;
    private List<AtlasPBRLoader.PBRTextureAtlasSprite> sprites = List.of();
    protected final Map<Identifier, AtlasPBRLoader.PBRTextureAtlasSprite> texturesByNameToAdd = new HashMap<Identifier, AtlasPBRLoader.PBRTextureAtlasSprite>();
    protected Map<Identifier, AtlasPBRLoader.PBRTextureAtlasSprite> texturesByName = new HashMap<Identifier, AtlasPBRLoader.PBRTextureAtlasSprite>();
    private List<SpriteContents.AnimationState> animatedTexturesStates = List.of();
    protected int width;
    protected int height;
    private GpuBuffer spriteUbos;
    private int mipLevelCount;
    private GpuTextureView[] mipViews = new GpuTextureView[0];
    private int maxMipLevel;
    private TextureAtlasSprite missingSprite;

    public PBRAtlasTexture(TextureAtlas atlasTexture, PBRType type) {
        this.atlasTexture = atlasTexture;
        this.type = type;
        this.location = Identifier.fromNamespaceAndPath((String)atlasTexture.location().getNamespace(), (String)(atlasTexture.location().getPath().replace(".png", "") + type.getSuffix() + ".png"));
    }

    public static void syncAnimation(SpriteContents.AnimatedTexture source, SpriteContents.AnimationState target) {
        int time;
        SpriteContentsTickerAccessor sourceAccessor = (SpriteContentsTickerAccessor)source;
        List<SpriteContents.FrameInfo> sourceFrames = ((SpriteContentsAnimatedTextureAccessor)sourceAccessor.getAnimationInfo()).getFrames();
        int ticks = 0;
        for (int f = 0; f < sourceAccessor.getFrame(); ++f) {
            ticks += ((SpriteContentsFrameInfoAccessor)sourceFrames.get(f)).getTime();
        }
        SpriteContentsTickerAccessor targetAccessor = (SpriteContentsTickerAccessor)target;
        List<SpriteContents.FrameInfo> targetFrames = ((SpriteContentsAnimatedTextureAccessor)targetAccessor.getAnimationInfo()).getFrames();
        int cycleTime = 0;
        int frameCount = targetFrames.size();
        for (SpriteContents.FrameInfo frame : targetFrames) {
            cycleTime += ((SpriteContentsFrameInfoAccessor)frame).getTime();
        }
        ticks %= cycleTime;
        int targetFrame = 0;
        while (ticks >= (time = ((SpriteContentsFrameInfoAccessor)targetFrames.get(targetFrame)).getTime())) {
            ++targetFrame;
            ticks -= time;
        }
        targetAccessor.setFrame(targetFrame);
        targetAccessor.setSubFrame(ticks + sourceAccessor.getSubFrame());
    }

    protected static void dumpSpriteNames(Path dir, String fileName, Map<Identifier, AtlasPBRLoader.PBRTextureAtlasSprite> sprites) {
        Path path = dir.resolve(fileName + ".txt");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (Map.Entry entry : sprites.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                AtlasPBRLoader.PBRTextureAtlasSprite sprite = (AtlasPBRLoader.PBRTextureAtlasSprite)((Object)entry.getValue());
                writer.write(String.format(Locale.ROOT, "%s\tx=%d\ty=%d\tw=%d\th=%d%n", entry.getKey(), sprite.getX(), sprite.getY(), sprite.contents().width(), sprite.contents().height()));
            }
        }
        catch (IOException e) {
            Iris.logger.warn("Failed to write file {}", path, e);
        }
    }

    public PBRType getType() {
        return this.type;
    }

    public Identifier getAtlasId() {
        return this.location;
    }

    public void addSprite(AtlasPBRLoader.PBRTextureAtlasSprite sprite) {
        this.texturesByNameToAdd.put(sprite.contents().name(), sprite);
    }

    @Nullable
    public AtlasPBRLoader.PBRTextureAtlasSprite getSprite(Identifier id) {
        return this.texturesByName.get(id);
    }

    public boolean tryUpload(int atlasWidth, int atlasHeight, int mipLevel) {
        try {
            this.upload(atlasWidth, atlasHeight, mipLevel);
            return true;
        }
        catch (Throwable t) {
            if (IrisPlatformHelpers.getInstance().isDevelopmentEnvironment()) {
                t.printStackTrace();
            }
            return false;
        }
    }

    private void createTexture(int i, int j, int k) {
        Iris.logger.info("Created: {}x{}x{} {}-atlas", i, j, k, this.location);
        GpuDevice gpuDevice = RenderSystem.getDevice();
        this.close();
        this.texture = gpuDevice.createTexture(() -> ((Identifier)this.location).toString(), 15, TextureFormat.RGBA8, i, j, 1, k + 1);
        this.textureView = gpuDevice.createTextureView(this.texture);
        this.width = i;
        this.height = j;
        this.maxMipLevel = k;
        this.mipLevelCount = k + 1;
        this.mipViews = new GpuTextureView[this.mipLevelCount];
        TextureManipulationUtil.fillWithColor(this.texture.iris$getGlId(), this.maxMipLevel, this.type.getDefaultValue());
        for (int l = 0; l <= this.maxMipLevel; ++l) {
            this.mipViews[l] = gpuDevice.createTextureView(this.texture, l, 1);
        }
    }

    public void clearTextureData() {
        this.sprites.forEach(TextureAtlasSprite::close);
        this.sprites = List.of();
        this.animatedTexturesStates = List.of();
        this.texturesByName = Map.of();
        this.missingSprite = null;
    }

    public void upload(int atlasWidth, int atlasHeight, int mipLevel) {
        this.createTexture(atlasWidth, atlasHeight, mipLevel);
        this.clearTextureData();
        this.sampler = RenderSystem.getSamplerCache().getClampToEdge(FilterMode.NEAREST);
        this.texturesByName = Map.copyOf(this.texturesByNameToAdd);
        this.missingSprite = null;
        ArrayList<AtlasPBRLoader.PBRTextureAtlasSprite> sprites = new ArrayList<AtlasPBRLoader.PBRTextureAtlasSprite>();
        ArrayList<SpriteContents.AnimationState> animationStates = new ArrayList<SpriteContents.AnimationState>();
        int animatedSpriteCount = (int)this.texturesByName.values().stream().filter(TextureAtlasSprite::isAnimated).count();
        int spriteUboSize = Mth.roundToward((int)SpriteContents.UBO_SIZE, (int)RenderSystem.getDevice().getUniformOffsetAlignment());
        int uboBlockSize = spriteUboSize * this.mipLevelCount;
        ByteBuffer spriteUboBuffer = MemoryUtil.memAlloc((int)(animatedSpriteCount * uboBlockSize));
        int animationIndex = 0;
        for (TextureAtlasSprite textureAtlasSprite : this.texturesByName.values()) {
            if (!textureAtlasSprite.isAnimated()) continue;
            textureAtlasSprite.uploadSpriteUbo(spriteUboBuffer, animationIndex * uboBlockSize, this.maxMipLevel, this.width, this.height, spriteUboSize);
            ++animationIndex;
        }
        GpuBuffer spriteUbos = animationIndex > 0 ? RenderSystem.getDevice().createBuffer(() -> String.valueOf(this.location) + " sprite UBOs", 128, spriteUboBuffer) : null;
        animationIndex = 0;
        for (AtlasPBRLoader.PBRTextureAtlasSprite spritex : this.texturesByName.values()) {
            sprites.add(spritex);
            if (!spritex.isAnimated() || spriteUbos == null) continue;
            SpriteContents.AnimationState animationState = spritex.createAnimationState(spriteUbos.slice((long)(animationIndex * uboBlockSize), (long)uboBlockSize), spriteUboSize);
            ++animationIndex;
            if (animationState == null) continue;
            animationStates.add(animationState);
        }
        this.spriteUbos = spriteUbos;
        this.sprites = sprites;
        this.animatedTexturesStates = List.copyOf(animationStates);
        this.uploadInitialContents();
        if (SharedConstants.DEBUG_DUMP_TEXTURE_ATLAS) {
            Path path = TextureUtil.getDebugTexturePath();
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                this.dumpContents(this.location, path);
            }
            catch (IOException var13) {
                Iris.logger.warn("Failed to dump atlas contents to {}", path);
            }
        }
        PBRAtlasHolder pBRAtlasHolder = ((TextureAtlasExtension)this.atlasTexture).getOrCreatePBRHolder();
        switch (this.type) {
            case NORMAL: {
                pBRAtlasHolder.setNormalAtlas(this);
                break;
            }
            case SPECULAR: {
                pBRAtlasHolder.setSpecularAtlas(this);
            }
        }
    }

    private void uploadInitialContents() {
        GpuDevice gpuDevice = RenderSystem.getDevice();
        int spriteUboSize = Mth.roundToward((int)SpriteContents.UBO_SIZE, (int)RenderSystem.getDevice().getUniformOffsetAlignment());
        int uboBlockSize = spriteUboSize * this.mipLevelCount;
        GpuSampler gpuSampler = RenderSystem.getSamplerCache().getClampToEdge(FilterMode.NEAREST);
        List<AtlasPBRLoader.PBRTextureAtlasSprite> staticSprites = this.sprites.stream().filter(textureAtlasSprite -> !textureAtlasSprite.isAnimated()).toList();
        ArrayList<GpuTextureView[]> scratchTextures = new ArrayList<GpuTextureView[]>();
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(staticSprites.size() * uboBlockSize));
        for (int k = 0; k < staticSprites.size(); ++k) {
            TextureAtlasSprite textureAtlasSprite2 = staticSprites.get(k);
            textureAtlasSprite2.uploadSpriteUbo(byteBuffer, k * uboBlockSize, this.maxMipLevel, this.width, this.height, spriteUboSize);
            GpuTexture gpuTexture = gpuDevice.createTexture(() -> textureAtlasSprite2.contents().name().toString(), 5, TextureFormat.RGBA8, textureAtlasSprite2.contents().width(), textureAtlasSprite2.contents().height(), 1, this.mipLevelCount);
            GpuTextureView[] gpuTextureViews = new GpuTextureView[this.mipLevelCount];
            for (int l = 0; l <= this.maxMipLevel; ++l) {
                textureAtlasSprite2.uploadFirstFrame(gpuTexture, l);
                gpuTextureViews[l] = gpuDevice.createTextureView(gpuTexture);
            }
            scratchTextures.add(gpuTextureViews);
        }
        try (GpuBuffer gpuBuffer = gpuDevice.createBuffer(() -> "SpriteAnimationInfo", 128, byteBuffer);){
            for (int level = 0; level < this.mipLevelCount; ++level) {
                try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Animate " + String.valueOf(this.location), this.mipViews[level], OptionalInt.empty());){
                    renderPass.setPipeline(RenderPipelines.ANIMATE_SPRITE_BLIT);
                    for (int n = 0; n < staticSprites.size(); ++n) {
                        renderPass.bindTexture("Sprite", ((GpuTextureView[])scratchTextures.get(n))[level], gpuSampler);
                        renderPass.setUniform("SpriteAnimationInfo", gpuBuffer.slice((long)(n * uboBlockSize + level * spriteUboSize), (long)SpriteContents.UBO_SIZE));
                        renderPass.draw(0, 6);
                    }
                    continue;
                }
            }
        }
        Iterator iterator = scratchTextures.iterator();
        while (iterator.hasNext()) {
            GpuTextureView[] views;
            for (GpuTextureView view : views = (GpuTextureView[])iterator.next()) {
                view.close();
                view.texture().close();
            }
        }
        MemoryUtil.memFree((Buffer)byteBuffer);
    }

    public void cycleAnimationFrames() {
        if (this.texture != null) {
            for (SpriteContents.AnimationState animationState : this.animatedTexturesStates) {
                animationState.tick();
            }
            if (this.animatedTexturesStates.stream().anyMatch(SpriteContents.AnimationState::needsToDraw)) {
                for (int i = 0; i <= this.maxMipLevel; ++i) {
                    try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Animate " + String.valueOf(this.location), this.mipViews[i], OptionalInt.empty());){
                        for (SpriteContents.AnimationState animationState2 : this.animatedTexturesStates) {
                            if (!animationState2.needsToDraw()) continue;
                            animationState2.drawToAtlas(renderPass, animationState2.getDrawUbo(i));
                        }
                        continue;
                    }
                }
            }
        }
    }

    public void close() {
        PBRAtlasHolder pbrHolder = ((TextureAtlasExtension)this.atlasTexture).getPBRHolder();
        if (pbrHolder != null) {
            switch (this.type) {
                case NORMAL: {
                    pbrHolder.setNormalAtlas(null);
                    break;
                }
                case SPECULAR: {
                    pbrHolder.setSpecularAtlas(null);
                }
            }
        }
        super.close();
        for (GpuTextureView gpuTextureView : this.mipViews) {
            gpuTextureView.close();
        }
        for (SpriteContents.AnimationState animationState : this.animatedTexturesStates) {
            animationState.close();
        }
        if (this.spriteUbos != null) {
            this.spriteUbos.close();
            this.spriteUbos = null;
        }
    }

    public void dumpContents(Identifier id, Path path) {
        String string = id.toDebugFileName();
        TextureUtil.writeAsPNG((Path)path, (String)string, (GpuTexture)this.getTexture(), (int)this.maxMipLevel, i -> i);
        PBRAtlasTexture.dumpSpriteNames(path, string, this.texturesByName);
    }

    @Override
    public Identifier getDefaultDumpLocation() {
        return this.location;
    }
}

