/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.uniforms;

import com.mojang.math.Axis;
import java.util.Objects;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.gl.uniform.UniformHolder;
import net.irisshaders.iris.gl.uniform.UniformUpdateFrequency;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.EndFlashState;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public final class CelestialUniforms {
    private static final Vector4f ZERO = new Vector4f();
    private final float sunPathRotation;

    public CelestialUniforms(float sunPathRotation) {
        this.sunPathRotation = sunPathRotation;
    }

    public static float getSunAngle(boolean sun) {
        float currentAngle = ((Float)Minecraft.getInstance().gameRenderer.getMainCamera().attributeProbe().getValue(sun ? EnvironmentAttributes.SUN_ANGLE : EnvironmentAttributes.MOON_ANGLE, CapturedRenderingState.INSTANCE.getTickDelta())).floatValue();
        float c = currentAngle + 90.0f;
        if (c < 0.0f) {
            c += 360.0f;
        } else if (c > 360.0f) {
            c -= 360.0f;
        }
        return c;
    }

    private static float getShadowAngle() {
        float shadowAngle = CelestialUniforms.getSunAngle(CelestialUniforms.isDay());
        return shadowAngle / 360.0f;
    }

    private static Vector4f getUpPosition() {
        Vector4f upVector = new Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f preCelestial = new Matrix4f(CapturedRenderingState.INSTANCE.getGbufferModelView());
        preCelestial.rotate((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        upVector = preCelestial.transform(upVector);
        return upVector;
    }

    public static boolean isDay() {
        int timeOfDay = Math.toIntExact(Minecraft.getInstance().level.getDayTime() % 24000L);
        return timeOfDay < 12751 || timeOfDay > 23251;
    }

    private static ClientLevel getWorld() {
        return Objects.requireNonNull(Minecraft.getInstance().level);
    }

    public void addCelestialUniforms(UniformHolder uniforms) {
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "sunAngle", () -> CelestialUniforms.getSunAngle(true) / 360.0f).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "sunPosition", this::getSunPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "moonPosition", this::getMoonPosition).uniform1f(UniformUpdateFrequency.PER_FRAME, "shadowAngle", CelestialUniforms::getShadowAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "shadowLightPosition", this::getShadowLightPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "endFlashPosition", () -> {
            if (Minecraft.getInstance().level.dimension() == Level.END) {
                return this.getEndFlashPosition();
            }
            return ZERO;
        }).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "upPosition", CelestialUniforms::getUpPosition);
    }

    private Vector4f getSunPosition() {
        return this.getCelestialPosition(true, 100.0f);
    }

    private Vector4f getMoonPosition() {
        return this.getCelestialPosition(false, -100.0f);
    }

    private Vector4f getEndFlashPosition() {
        EndFlashState state = Minecraft.getInstance().level.endFlashState();
        float h = state.getYAngle();
        float g = state.getXAngle();
        Vector4f pos = new Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f m = new Matrix4f(CapturedRenderingState.INSTANCE.getGbufferModelView());
        m.rotate((Quaternionfc)Axis.YP.rotationDegrees(180.0f - h));
        m.rotate((Quaternionfc)Axis.XP.rotationDegrees(-90.0f - g));
        return m.transform(pos);
    }

    private Vector4f getEndFlashPositionInWorldSpace() {
        EndFlashState state = Minecraft.getInstance().level.endFlashState();
        float h = state.getYAngle();
        float g = state.getXAngle();
        Vector4f pos = new Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f m = new Matrix4f();
        m.identity();
        m.rotate((Quaternionfc)Axis.YP.rotationDegrees(180.0f - h));
        m.rotate((Quaternionfc)Axis.XP.rotationDegrees(-90.0f - g));
        return m.transform(pos);
    }

    public Vector4f getShadowLightPosition() {
        if (Minecraft.getInstance().level.dimension() == Level.END && Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::supportsEndFlash).orElse(false).booleanValue()) {
            return this.getEndFlashPosition();
        }
        return CelestialUniforms.isDay() ? this.getSunPosition() : this.getMoonPosition();
    }

    public Vector4f getShadowLightPositionInWorldSpace() {
        if (Minecraft.getInstance().level.dimension() == Level.END && Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::supportsEndFlash).orElse(false).booleanValue()) {
            return this.getEndFlashPositionInWorldSpace();
        }
        return CelestialUniforms.isDay() ? this.getCelestialPositionInWorldSpace(true, 100.0f) : this.getCelestialPositionInWorldSpace(false, -100.0f);
    }

    private Vector4f getCelestialPositionInWorldSpace(boolean sun, float y) {
        Vector4f position = new Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f celestial = new Matrix4f();
        celestial.identity();
        celestial.rotate((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        celestial.rotate((Quaternionfc)Axis.ZP.rotationDegrees(this.sunPathRotation));
        float currentAngle = ((Float)Minecraft.getInstance().gameRenderer.getMainCamera().attributeProbe().getValue(sun ? EnvironmentAttributes.SUN_ANGLE : EnvironmentAttributes.MOON_ANGLE, CapturedRenderingState.INSTANCE.getTickDelta())).floatValue();
        celestial.rotate((Quaternionfc)Axis.XP.rotationDegrees(currentAngle));
        celestial.transform(position);
        return position;
    }

    private Vector4f getCelestialPosition(boolean sun, float y) {
        Vector4f position = new Vector4f(0.0f, 100.0f, 0.0f, 1.0f);
        Matrix4f celestial = new Matrix4f(CapturedRenderingState.INSTANCE.getGbufferModelView());
        celestial.rotate((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        celestial.rotate((Quaternionfc)Axis.ZP.rotationDegrees(this.sunPathRotation));
        float currentAngle = ((Float)Minecraft.getInstance().gameRenderer.getMainCamera().attributeProbe().getValue(sun ? EnvironmentAttributes.SUN_ANGLE : EnvironmentAttributes.MOON_ANGLE, CapturedRenderingState.INSTANCE.getTickDelta())).floatValue();
        celestial.rotate((Quaternionfc)Axis.XP.rotationDegrees(currentAngle));
        position = celestial.transform(position);
        return position;
    }
}

