/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.uniforms;

import java.util.Objects;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.gl.uniform.UniformHolder;
import net.irisshaders.iris.gl.uniform.UniformUpdateFrequency;
import net.irisshaders.iris.shaderpack.DimensionId;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.level.MoonPhase;

public final class WorldTimeUniforms {
    private WorldTimeUniforms() {
    }

    public static void addWorldTimeUniforms(UniformHolder uniforms) {
        uniforms.uniform1i(UniformUpdateFrequency.PER_TICK, "worldTime", WorldTimeUniforms::getWorldDayTime).uniform1i(UniformUpdateFrequency.PER_TICK, "worldDay", WorldTimeUniforms::getWorldDay).uniform1i(UniformUpdateFrequency.PER_TICK, "moonPhase", () -> ((MoonPhase)Minecraft.getInstance().gameRenderer.getMainCamera().attributeProbe().getValue(EnvironmentAttributes.MOON_PHASE, CapturedRenderingState.INSTANCE.getTickDelta())).index());
    }

    static int getWorldDayTime() {
        long timeOfDay = WorldTimeUniforms.getWorld().getDayTime();
        if (Iris.getCurrentDimension() == DimensionId.END || Iris.getCurrentDimension() == DimensionId.NETHER) {
            return (int)(timeOfDay % 24000L);
        }
        long dayTime = WorldTimeUniforms.getWorld().dimensionType().hasFixedTime() ? 0L : timeOfDay % 24000L;
        return (int)dayTime;
    }

    private static int getWorldDay() {
        long timeOfDay = WorldTimeUniforms.getWorld().getDayTime();
        long day = timeOfDay / 24000L;
        return (int)day;
    }

    private static ClientLevel getWorld() {
        return Objects.requireNonNull(Minecraft.getInstance().level);
    }
}

