/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.recipes;

import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.ICraftingStationLookup;
import mezz.jei.api.recipe.IRecipeCatalystLookup;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.library.recipes.RecipeManagerInternal;
import net.minecraft.world.item.ItemStack;

public class CraftingStationLookup
implements IRecipeCatalystLookup,
ICraftingStationLookup {
    private final IRecipeType<?> recipeType;
    private final RecipeManagerInternal recipeManager;
    private boolean includeHidden;

    public CraftingStationLookup(IRecipeType<?> recipeType, RecipeManagerInternal recipeManager) {
        this.recipeType = recipeType;
        this.recipeManager = recipeManager;
    }

    @Override
    public CraftingStationLookup includeHidden() {
        this.includeHidden = true;
        return this;
    }

    @Override
    public Stream<ITypedIngredient<?>> get() {
        return this.recipeManager.getCraftingStations(this.recipeType, this.includeHidden);
    }

    public <V> Stream<V> get(IIngredientType<V> ingredientType) {
        return this.get().map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream);
    }

    @Override
    public Stream<ItemStack> getItemStack() {
        return this.get((IIngredientType)VanillaTypes.ITEM_STACK);
    }
}

