/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge.network;

import java.util.UUID;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketDeletePlayerItem;
import mezz.jei.common.network.packets.PlayToServerPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.jspecify.annotations.Nullable;

public final class ConnectionToServer
implements IConnectionToServer {
    private static @Nullable UUID jeiOnServerCacheUuid = null;
    private static boolean jeiOnServerCacheValue = false;

    @Override
    public boolean isJeiOnServer() {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener clientPacketListener = minecraft.getConnection();
        if (clientPacketListener == null || !clientPacketListener.getConnection().isConnected()) {
            return false;
        }
        UUID id = clientPacketListener.getId();
        if (!id.equals(jeiOnServerCacheUuid)) {
            jeiOnServerCacheUuid = id;
            jeiOnServerCacheValue = clientPacketListener.hasChannel(PacketDeletePlayerItem.TYPE);
        }
        return jeiOnServerCacheValue;
    }

    @Override
    public <T extends PlayToServerPacket<T>> void sendPacketToServer(T packet) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener netHandler = minecraft.getConnection();
        if (netHandler != null && this.isJeiOnServer()) {
            ClientPacketDistributor.sendToServer(packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

