/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.BiomeAccessor2;
import dev.worldgen.lithostitched.worldgen.modifier.util.BiomeClimate;
import dev.worldgen.lithostitched.worldgen.modifier.util.BiomeEffects;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.attribute.AmbientSounds;
import net.minecraft.world.attribute.BackgroundMusic;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeSpecialEffectsBuilder;
import net.neoforged.neoforge.common.world.ClimateSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public class LithostitchedNeoforgeBiomeModifiers {

    public record ReplaceEffectsBiomeModifier(HolderSet<Biome> biomes, BiomeEffects specialEffects) implements BiomeModifier
    {
        public static final MapCodec<ReplaceEffectsBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ReplaceEffectsBiomeModifier::biomes), (App)BiomeEffects.CODEC.fieldOf("effects").forGetter(ReplaceEffectsBiomeModifier::specialEffects)).apply((Applicative)builder, ReplaceEffectsBiomeModifier::new));

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder info) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes().contains(biome)) {
                BiomeSpecialEffectsBuilder builder = info.getSpecialEffects();
                this.applyEffect(BiomeEffects::waterColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).waterColor(arg_0));
                this.applyEffect(BiomeEffects::foliageColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).foliageColorOverride(arg_0));
                this.applyEffect(BiomeEffects::dryFoliageColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).dryFoliageColorOverride(arg_0));
                this.applyEffect(BiomeEffects::grassColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).grassColorOverride(arg_0));
                this.applyEffect(BiomeEffects::grassColorModifier, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).grassColorModifier(arg_0));
                BiomeAccessor2 accessor = (BiomeAccessor2)biome.value();
                EnvironmentAttributeMap attributes = ((Biome)biome.value()).getAttributes();
                EnvironmentAttributeMap.Builder attributeBuilder = EnvironmentAttributeMap.builder();
                attributeBuilder.putAll(attributes);
                this.applyAttribute(attributeBuilder, BiomeEffects::fogColor, EnvironmentAttributes.FOG_COLOR);
                this.applyAttribute(attributeBuilder, BiomeEffects::waterFogColor, EnvironmentAttributes.WATER_FOG_COLOR);
                this.applyAttribute(attributeBuilder, BiomeEffects::skyColor, EnvironmentAttributes.SKY_COLOR);
                this.applyAttribute(attributeBuilder, e -> Optional.of(e.ambientParticle().map(List::of).orElse(List.of())), EnvironmentAttributes.AMBIENT_PARTICLES);
                this.applyAttribute(attributeBuilder, e -> Optional.of(new AmbientSounds(e.ambientSound(), e.moodSound(), e.additionsSound().map(List::of).orElse(List.of()))), EnvironmentAttributes.AMBIENT_SOUNDS);
                this.applyAttribute(attributeBuilder, e -> Optional.of(new BackgroundMusic(e.music(), Optional.empty(), Optional.empty())), EnvironmentAttributes.BACKGROUND_MUSIC);
                this.applyAttribute(attributeBuilder, BiomeEffects::musicVolume, EnvironmentAttributes.MUSIC_VOLUME);
                accessor.setAttributes(attributeBuilder.build());
            }
        }

        private <T> void applyEffect(Function<BiomeEffects, Optional<T>> getter, Consumer<T> applier) {
            getter.apply(this.specialEffects).ifPresent(applier);
        }

        private <T> void applyAttribute(EnvironmentAttributeMap.Builder builder, Function<BiomeEffects, Optional<T>> getter, EnvironmentAttribute<T> attribute) {
            Optional<Object> value = getter.apply(this.specialEffects);
            value.ifPresent(object -> builder.set(attribute, object));
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }

    public record ReplaceClimateBiomeModifier(HolderSet<Biome> biomes, BiomeClimate climateSettings) implements BiomeModifier
    {
        public static final MapCodec<ReplaceClimateBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ReplaceClimateBiomeModifier::biomes), (App)BiomeClimate.CODEC.fieldOf("climate").forGetter(ReplaceClimateBiomeModifier::climateSettings)).apply((Applicative)builder, ReplaceClimateBiomeModifier::new));

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes().contains(biome)) {
                ClimateSettingsBuilder climateSettings = builder.getClimateSettings();
                this.tryApply(this.climateSettings.temperature(), arg_0 -> ((ClimateSettingsBuilder)climateSettings).setTemperature(arg_0));
                this.tryApply(this.climateSettings.temperatureModifier(), arg_0 -> ((ClimateSettingsBuilder)climateSettings).setTemperatureModifier(arg_0));
                this.tryApply(this.climateSettings.hasPrecipitation(), arg_0 -> ((ClimateSettingsBuilder)climateSettings).setHasPrecipitation(arg_0));
                this.tryApply(this.climateSettings.downfall(), arg_0 -> ((ClimateSettingsBuilder)climateSettings).setDownfall(arg_0));
            }
        }

        private <T> void tryApply(Optional<T> value, Consumer<T> consumer) {
            value.ifPresent(consumer::accept);
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }
}

