/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.poolelement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.Lithostitched;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.placementcondition.PlacementCondition;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;

public record DelegatingConfig(StructurePoolElement delegate, Optional<Identifier> name, Optional<PlacementCondition> placementCondition, Optional<InclusiveRange<Integer>> allowedDepth, Optional<Integer> forcedCount, Optional<Integer> maxCount, boolean allowBoundingBoxCollisions, boolean otherPiecesCanIntersect, Optional<TerrainAdjustment> overrideTerrainAdaption) {
    public static final MapCodec<DelegatingConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StructurePoolElement.CODEC.fieldOf("delegate").forGetter(DelegatingConfig::delegate), (App)Identifier.CODEC.optionalFieldOf("name").forGetter(DelegatingConfig::name), (App)PlacementCondition.CODEC.optionalFieldOf("condition").forGetter(DelegatingConfig::placementCondition), (App)LithostitchedCodecs.INT_RANGE.optionalFieldOf("allowed_depth").forGetter(DelegatingConfig::allowedDepth), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("forced_count").forGetter(DelegatingConfig::forcedCount), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("max_count").forGetter(DelegatingConfig::maxCount), (App)Codec.BOOL.optionalFieldOf("allow_bounding_box_collisions", (Object)false).forGetter(DelegatingConfig::allowBoundingBoxCollisions), (App)Codec.BOOL.optionalFieldOf("other_pieces_can_intersect", (Object)false).forGetter(DelegatingConfig::otherPiecesCanIntersect), (App)TerrainAdjustment.CODEC.optionalFieldOf("override_terrain_adaption").forGetter(DelegatingConfig::overrideTerrainAdaption)).apply((Applicative)instance, DelegatingConfig::new)).validate(DelegatingConfig::validate);

    public DelegatingConfig(StructurePoolElement delegate) {
        this(delegate, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), false, false, Optional.empty());
    }

    private static DataResult<DelegatingConfig> validate(DelegatingConfig config) {
        if (config.forcedCount.isPresent() && config.maxCount.isPresent()) {
            return DataResult.error(() -> "forced_count and max_count cannot both be present.");
        }
        return DataResult.success((Object)config);
    }

    public Identifier getName() {
        return this.name.orElseGet(() -> Lithostitched.id("generated/" + this.delegate.hashCode()));
    }

    public boolean shouldCancelPlacement(Structure.GenerationContext context, BlockPos pos, int depth, int count) {
        boolean validDepth = this.allowedDepth.map(range -> range.isValueInRange((Comparable)Integer.valueOf(depth))).orElse(true);
        boolean validCount = this.forcedCount.map(forced -> count < forced).orElse(true) != false && this.maxCount.map(max -> count < max).orElse(true) != false;
        boolean validCondition = this.placementCondition.map(condition -> condition.test(context, pos)).orElse(true);
        return !validDepth || !validCount || !validCondition;
    }
}

