/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.google.common.collect.Lists;
import dev.worldgen.lithostitched.Lithostitched;
import dev.worldgen.lithostitched.config.ConfigHandler;
import dev.worldgen.lithostitched.duck.StructurePoolAccess;
import dev.worldgen.lithostitched.worldgen.poolelement.DelegatingConfig;
import dev.worldgen.lithostitched.worldgen.poolelement.DelegatingPoolElement;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawConfig;
import dev.worldgen.lithostitched.worldgen.structure.BoxOctree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableObject;

public class AlternateJigsawGenerator {
    public static Optional<Structure.GenerationStub> generate(Structure.GenerationContext context, AlternateJigsawConfig config, boolean vanilla, int size, BlockPos pos, PoolAliasLookup aliasLookup) {
        BlockPos startPos;
        RegistryAccess registries = context.registryAccess();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        StructureTemplateManager structureTemplateManager = context.structureTemplateManager();
        LevelHeightAccessor heightLimitView = context.heightAccessor();
        WorldgenRandom random = context.random();
        Registry registry = registries.lookupOrThrow(Registries.TEMPLATE_POOL);
        Rotation rotation = config.fixedRotation() ? Rotation.NONE : Rotation.getRandom((RandomSource)random);
        StructurePoolElement startingElement = config.startPool().unwrapKey().flatMap(resourceKey -> registry.getOptional(aliasLookup.lookup(resourceKey))).orElse((StructureTemplatePool)config.startPool().value()).getRandomTemplate((RandomSource)random);
        if (startingElement == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        Optional<Identifier> startJigsawName = config.startJigsawName();
        if (startJigsawName.isPresent()) {
            Identifier identifier = startJigsawName.get();
            Optional<BlockPos> optional = AlternateJigsawGenerator.findNamedJigsaw(startingElement, identifier, pos, rotation, structureTemplateManager, random);
            if (optional.isEmpty()) {
                Lithostitched.LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)identifier, (Object)config.startPool().unwrapKey().map(key -> key.identifier().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            startPos = optional.get();
        } else {
            startPos = pos;
        }
        BlockPos vec3i = startPos.subtract((Vec3i)pos);
        BlockPos blockPos2 = pos.subtract((Vec3i)vec3i);
        PoolElementStructurePiece piece = new PoolElementStructurePiece(structureTemplateManager, startingElement, blockPos2, startingElement.getGroundLevelDelta(), rotation, startingElement.getBoundingBox(structureTemplateManager, blockPos2, rotation), config.liquidSettings());
        BoundingBox blockBox = piece.getBoundingBox();
        int originX = (blockBox.maxX() + blockBox.minX()) / 2;
        int originZ = (blockBox.maxZ() + blockBox.minZ()) / 2;
        Optional y = config.startProjection().map(either -> (Optional)either.map(snap -> snap.findY(new BlockPos(originX, blockPos2.getY(), originZ), context, heightLimitView, context.randomState()), type -> Optional.of(pos.getY() + chunkGenerator.getFirstFreeHeight(originX, originZ, type, heightLimitView, context.randomState())))).orElseGet(() -> Optional.of(blockPos2.getY()));
        if (y.isEmpty()) {
            return Optional.empty();
        }
        int l = blockBox.minY() + piece.getGroundLevelDelta();
        piece.move(0, (Integer)y.get() - l, 0);
        if (AlternateJigsawGenerator.pieceWithinPaddingBounds(heightLimitView, config.dimensionPadding(), piece.getBoundingBox())) {
            return Optional.empty();
        }
        int originY = (Integer)y.get() + vec3i.getY();
        return Optional.of(new Structure.GenerationStub(new BlockPos(originX, originY, originZ), collector -> {
            ArrayList list = Lists.newArrayList();
            list.add(piece);
            if (size > 0) {
                AlternateJigsawConfig.MaxDistance maxDistance = config.maxDistanceFromCenter();
                AABB box = new AABB((double)(originX - maxDistance.horizontal()), (double)Math.max(originY - maxDistance.vertical(), heightLimitView.getMinY() + config.dimensionPadding().bottom()), (double)(originZ - maxDistance.horizontal()), (double)(originX + maxDistance.horizontal() + 1), (double)Math.min(originY + maxDistance.vertical() + 1, heightLimitView.getMaxY() - config.dimensionPadding().top()), (double)(originZ + maxDistance.horizontal() + 1));
                BoxOctree boxOctree = new BoxOctree(box);
                if (!AlternateJigsawGenerator.getConfig(startingElement).otherPiecesCanIntersect()) {
                    boxOctree.addBox(AABB.of((BoundingBox)blockBox));
                }
                AlternateJigsawGenerator.generatePieces(context, vanilla, size, config.useExpansionHack(), chunkGenerator, structureTemplateManager, heightLimitView, (RandomSource)random, (Registry<StructureTemplatePool>)registry, piece, list, boxOctree, aliasLookup, config.liquidSettings());
            }
            Objects.requireNonNull(collector);
            list.forEach(arg_0 -> ((StructurePiecesBuilder)collector).addPiece(arg_0));
        }));
    }

    private static boolean pieceWithinPaddingBounds(LevelHeightAccessor levelHeightAccessor, DimensionPadding dimensionPadding, BoundingBox boundingBox) {
        if (dimensionPadding == DimensionPadding.ZERO) {
            return false;
        }
        int minY = levelHeightAccessor.getMinY() + dimensionPadding.bottom();
        int maxY = levelHeightAccessor.getMaxY() - dimensionPadding.top();
        return boundingBox.minY() < minY || boundingBox.maxY() > maxY;
    }

    private static Optional<BlockPos> findNamedJigsaw(StructurePoolElement pool, Identifier name, BlockPos pos, Rotation rotation, StructureTemplateManager structureManager, WorldgenRandom random) {
        List list = pool.getShuffledJigsawBlocks(structureManager, pos, rotation, (RandomSource)random);
        for (StructureTemplate.JigsawBlockInfo jigsawBlock : list) {
            if (!name.equals((Object)jigsawBlock.name())) continue;
            return Optional.of(jigsawBlock.info().pos());
        }
        return Optional.empty();
    }

    private static void generatePieces(Structure.GenerationContext context, boolean vanilla, int maxSize, boolean useExpansionHack, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, LevelHeightAccessor heightLimitView, RandomSource random, Registry<StructureTemplatePool> structurePoolRegistry, PoolElementStructurePiece firstPiece, List<PoolElementStructurePiece> pieces, BoxOctree boxOctree, PoolAliasLookup aliasLookup, LiquidSettings liquidSettings) {
        StructurePoolGenerator generator = new StructurePoolGenerator(context, vanilla, structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        generator.generatePiece(firstPiece, boxOctree, 0, useExpansionHack, heightLimitView, aliasLookup, liquidSettings);
        while (generator.pieces.hasNext()) {
            PieceState pieceState = (PieceState)generator.pieces.next();
            generator.generatePiece(pieceState.piece, pieceState.octree, pieceState.currentSize, useExpansionHack, heightLimitView, aliasLookup, liquidSettings);
        }
    }

    private static DelegatingConfig getConfig(StructurePoolElement element) {
        DelegatingConfig delegatingConfig;
        if (element instanceof DelegatingPoolElement) {
            DelegatingPoolElement delegating = (DelegatingPoolElement)element;
            delegatingConfig = delegating.config();
        } else {
            delegatingConfig = new DelegatingConfig(element);
        }
        return delegatingConfig;
    }

    static final class StructurePoolGenerator {
        private final Structure.GenerationContext context;
        private final boolean vanilla;
        private final Registry<StructureTemplatePool> registry;
        private final int maxSize;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> piecesToPlace;
        private final RandomSource random;
        private final Map<Identifier, Integer> groupCounts = new HashMap<Identifier, Integer>();
        final SequencedPriorityIterator<PieceState> pieces = new SequencedPriorityIterator();

        private StructurePoolGenerator(Structure.GenerationContext context, boolean vanilla, Registry<StructureTemplatePool> registry, int maxSize, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, List<? super PoolElementStructurePiece> children, RandomSource random) {
            this.context = context;
            this.vanilla = vanilla;
            this.registry = registry;
            this.maxSize = maxSize;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.piecesToPlace = children;
            this.random = random;
        }

        private void generatePiece(PoolElementStructurePiece parentPiece, BoxOctree parentOctree, int depth, boolean useExpansionHack, LevelHeightAccessor world, PoolAliasLookup aliasLookup, LiquidSettings liquidSettings) {
            StructurePoolElement anchorElement = parentPiece.getElement();
            BoundingBox parentBoundingBox = parentPiece.getBoundingBox();
            BoxOctree directParentOctree = null;
            for (StructureTemplate.JigsawBlockInfo anchorJigsaw : anchorElement.getShuffledJigsawBlocks(this.structureTemplateManager, parentPiece.getPosition(), parentPiece.getRotation(), this.random)) {
                BoxOctree octree;
                StructureTemplate.StructureBlockInfo anchorInfo = anchorJigsaw.info();
                BlockPos candidateConnectorPos = StructurePoolGenerator.adjustJigsawPos(anchorInfo);
                Holder<StructureTemplatePool> poolEntry = this.getTemplatePoolHolder((ResourceKey<StructureTemplatePool>)aliasLookup.lookup(anchorJigsaw.pool()));
                if (poolEntry == null) continue;
                boolean connectorInParentBoundingBox = parentBoundingBox.isInside((Vec3i)candidateConnectorPos);
                if (connectorInParentBoundingBox && !AlternateJigsawGenerator.getConfig(anchorElement).otherPiecesCanIntersect()) {
                    if (directParentOctree == null) {
                        directParentOctree = new BoxOctree(AABB.of((BoundingBox)parentBoundingBox));
                    }
                    octree = directParentOctree;
                } else {
                    octree = parentOctree;
                }
                MutableObject checkedPools = new MutableObject(new ArrayList());
                this.findAndTestChildCandidates(poolEntry, (MutableObject<List<ResourceKey<StructureTemplatePool>>>)checkedPools, parentPiece, anchorJigsaw, octree, -1, depth, useExpansionHack, world, true, aliasLookup, liquidSettings);
            }
        }

        private void findAndTestChildCandidates(Holder<StructureTemplatePool> entry, MutableObject<List<ResourceKey<StructureTemplatePool>>> checkedPools, PoolElementStructurePiece parentPiece, StructureTemplate.JigsawBlockInfo anchorJigsawInfo, BoxOctree octree, int k, int depth, boolean useExpansionHack, LevelHeightAccessor world, boolean firstIteration, PoolAliasLookup aliasLookup, LiquidSettings liquidSettings) {
            List<StructurePoolElement> childCandidates = this.getPoolElements((ResourceKey<StructureTemplatePool>)entry.unwrapKey().orElse(Pools.EMPTY), checkedPools, depth, firstIteration);
            if (childCandidates.isEmpty()) {
                return;
            }
            boolean foundChild = this.findValidChildPiece(childCandidates, parentPiece, anchorJigsawInfo, octree, k, depth, useExpansionHack, world, aliasLookup, liquidSettings);
            if (!foundChild) {
                this.findAndTestChildCandidates((Holder<StructureTemplatePool>)((StructureTemplatePool)entry.value()).getFallback(), checkedPools, parentPiece, anchorJigsawInfo, octree, k, depth, useExpansionHack, world, false, aliasLookup, liquidSettings);
            }
        }

        private List<StructurePoolElement> getPoolElements(ResourceKey<StructureTemplatePool> poolKey, MutableObject<List<ResourceKey<StructureTemplatePool>>> checkedPools, int depth, boolean firstIteration) {
            if (poolKey == Pools.EMPTY) {
                return List.of();
            }
            if (ConfigHandler.getConfig().breaksSeedParity() || !this.vanilla) {
                if (((List)checkedPools.getValue()).contains(poolKey)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (ResourceKey checkedPoolKey : (List)checkedPools.getValue()) {
                        stringBuilder.append(checkedPoolKey.identifier()).append(" -> ");
                    }
                    stringBuilder.append(poolKey.identifier());
                    Lithostitched.debug("Template pool fallback chain found: {}", stringBuilder);
                    return List.of();
                }
                ((List)checkedPools.getValue()).add(poolKey);
                Holder pool = (Holder)this.registry.get(poolKey).orElseThrow();
                if (depth == this.maxSize && firstIteration) {
                    pool = ((StructureTemplatePool)pool.value()).getFallback();
                }
                return ((StructurePoolAccess)pool.value()).getLithostitchedTemplates().shuffle(this.random);
            }
            if (!firstIteration) {
                return List.of();
            }
            Holder pool = (Holder)this.registry.get(poolKey).orElseThrow();
            Holder fallback = ((StructureTemplatePool)pool.value()).getFallback();
            ArrayList<StructurePoolElement> elements = new ArrayList<StructurePoolElement>();
            if (depth != this.maxSize) {
                elements.addAll(((StructureTemplatePool)pool.value()).getShuffledTemplates(this.random));
            }
            elements.addAll(((StructureTemplatePool)fallback.value()).getShuffledTemplates(this.random));
            return elements;
        }

        private boolean findValidChildPiece(List<StructurePoolElement> elements, PoolElementStructurePiece parentPiece, StructureTemplate.JigsawBlockInfo anchorJigsaw, BoxOctree octree, int k, int depth, boolean useExpansionHack, LevelHeightAccessor world, PoolAliasLookup aliasLookup, LiquidSettings liquidSettings) {
            StructureTemplate.StructureBlockInfo anchorInfo = anchorJigsaw.info();
            BlockPos anchorPos = anchorInfo.pos();
            BlockPos candidateConnectorPos = StructurePoolGenerator.adjustJigsawPos(anchorInfo);
            int parentMinY = parentPiece.getBoundingBox().minY();
            int anchorDistanceToFloor = anchorPos.getY() - parentMinY;
            StructureTemplatePool.Projection parentProjection = parentPiece.getElement().getProjection();
            boolean parentRigid = parentProjection == StructureTemplatePool.Projection.RIGID;
            for (StructurePoolElement element : elements) {
                if (element == EmptyPoolElement.INSTANCE) {
                    return true;
                }
                DelegatingConfig config = new DelegatingConfig(element);
                boolean isDelegating = false;
                if (element instanceof DelegatingPoolElement) {
                    DelegatingPoolElement delegating = (DelegatingPoolElement)element;
                    config = delegating.config();
                    isDelegating = true;
                    if (config.shouldCancelPlacement(this.context, candidateConnectorPos, depth, this.groupCounts.getOrDefault(config.getName(), 0))) continue;
                }
                for (Rotation rotation : Rotation.getShuffled((RandomSource)this.random)) {
                    List connectorJigsaws = element.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPos.ZERO, rotation, this.random);
                    BoundingBox connectorBoundingBox = element.getBoundingBox(this.structureTemplateManager, BlockPos.ZERO, rotation);
                    int l = useExpansionHack && connectorBoundingBox.getYSpan() <= 16 ? connectorJigsaws.stream().mapToInt(jigsawInfo -> {
                        StructureTemplate.StructureBlockInfo blockInfo = jigsawInfo.info();
                        if (!connectorBoundingBox.isInside((Vec3i)StructurePoolGenerator.adjustJigsawPos(blockInfo))) {
                            return 0;
                        }
                        ResourceKey registryKey2 = aliasLookup.lookup(jigsawInfo.pool());
                        Optional optional1 = this.registry.get(registryKey2);
                        Optional<Holder> optional2 = optional1.map(entry -> ((StructureTemplatePool)entry.value()).getFallback());
                        int i2 = optional1.map(entry -> ((StructureTemplatePool)entry.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                        int j2 = optional2.map(entry -> ((StructureTemplatePool)entry.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                        return Math.max(i2, j2);
                    }).max().orElse(0) : 0;
                    for (StructureTemplate.JigsawBlockInfo connectorJigsawInfo : connectorJigsaws) {
                        int t;
                        int r;
                        int p;
                        if (!JigsawBlock.canAttach((StructureTemplate.JigsawBlockInfo)anchorJigsaw, (StructureTemplate.JigsawBlockInfo)connectorJigsawInfo)) continue;
                        BlockPos connectorPos = connectorJigsawInfo.info().pos();
                        BlockPos blockPos5 = candidateConnectorPos.subtract((Vec3i)connectorPos);
                        BoundingBox blockBox3 = element.getBoundingBox(this.structureTemplateManager, blockPos5, rotation);
                        int m = blockBox3.minY();
                        StructureTemplatePool.Projection connectorProjection = element.getProjection();
                        boolean connectorProjectionRigid = connectorProjection == StructureTemplatePool.Projection.RIGID;
                        int connectorY = connectorPos.getY();
                        int o = anchorDistanceToFloor - connectorY + JigsawBlock.getFrontFacing((BlockState)anchorInfo.state()).getStepY();
                        if (parentRigid && connectorProjectionRigid) {
                            p = parentMinY + o;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.getFirstFreeHeight(anchorPos.getX(), anchorPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, world, this.context.randomState());
                            }
                            p = k - connectorY;
                        }
                        int q = p - m;
                        BoundingBox blockBox4 = blockBox3.moved(0, q, 0);
                        BlockPos blockPos6 = blockPos5.offset(0, q, 0);
                        if (l > 0) {
                            r = Math.max(l + 1, blockBox4.maxY() - blockBox4.minY());
                            blockBox4.encapsulate(new BlockPos(blockBox4.minX(), blockBox4.minY() + r, blockBox4.minZ()));
                        }
                        if (!config.allowBoundingBoxCollisions() && !octree.withinBoundsButNotIntersectingChildren(AABB.of((BoundingBox)blockBox4).deflate(0.25))) continue;
                        if (isDelegating) {
                            this.groupCounts.put(config.getName(), this.groupCounts.getOrDefault(config.getName(), 0) + 1);
                        }
                        if (!config.otherPiecesCanIntersect()) {
                            octree.addBox(AABB.of((BoundingBox)blockBox4));
                        }
                        r = parentPiece.getGroundLevelDelta();
                        int s = connectorProjectionRigid ? r - o : element.getGroundLevelDelta();
                        PoolElementStructurePiece poolStructurePiece = new PoolElementStructurePiece(this.structureTemplateManager, element, blockPos6, s, rotation, blockBox4, liquidSettings);
                        if (parentRigid) {
                            t = parentMinY + anchorDistanceToFloor;
                        } else if (connectorProjectionRigid) {
                            t = p + connectorY;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.getFirstFreeHeight(anchorPos.getX(), anchorPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, world, this.context.randomState());
                            }
                            t = k + o / 2;
                        }
                        parentPiece.addJunction(new JigsawJunction(candidateConnectorPos.getX(), t - anchorDistanceToFloor + r, candidateConnectorPos.getZ(), o, connectorProjection));
                        poolStructurePiece.addJunction(new JigsawJunction(anchorPos.getX(), t - connectorY + s, anchorPos.getZ(), -o, parentProjection));
                        this.piecesToPlace.add((PoolElementStructurePiece)poolStructurePiece);
                        if (depth + 1 <= this.maxSize) {
                            PieceState pieceState = new PieceState(poolStructurePiece, octree, depth + 1);
                            this.pieces.add((Object)pieceState, anchorJigsaw.placementPriority());
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private Holder<StructureTemplatePool> getTemplatePoolHolder(ResourceKey<StructureTemplatePool> key) {
            Optional optional = this.registry.get(key);
            if (optional.isEmpty()) {
                Lithostitched.LOGGER.warn("Couldn't find template pool reference: {}", (Object)key.identifier());
            } else {
                Holder regularPool = (Holder)optional.get();
                if (((StructureTemplatePool)regularPool.value()).size() == 0) {
                    if (!regularPool.is(Pools.EMPTY)) {
                        Lithostitched.LOGGER.warn("Referenced template pool is empty: {}", (Object)key.identifier());
                    }
                } else {
                    return regularPool;
                }
            }
            return null;
        }

        private static BlockPos adjustJigsawPos(StructureTemplate.StructureBlockInfo jigsawInfo) {
            return jigsawInfo.pos().relative(JigsawBlock.getFrontFacing((BlockState)jigsawInfo.state()));
        }
    }

    private record PieceState(PoolElementStructurePiece piece, BoxOctree octree, int currentSize) {
    }
}

