/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.noisium.mixin.compat.lithium;

import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={NoiseBasedChunkGenerator.class})
public abstract class LithiumNoiseChunkGeneratorMixin
extends ChunkGenerator {
    @Shadow
    protected abstract ChunkAccess doFill(Blender var1, StructureManager var2, RandomState var3, ChunkAccess var4, int var5, int var6);

    public LithiumNoiseChunkGeneratorMixin(BiomeSource biomeSource) {
        super(biomeSource);
    }

    @Redirect(method={"doFill(Lnet/minecraft/world/level/levelgen/blending/Blender;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/chunk/ChunkAccess;II)Lnet/minecraft/world/level/chunk/ChunkAccess;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunkSection;setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"))
    private BlockState noisium$populateNoiseWrapSetBlockStateOperation(@NotNull LevelChunkSection chunkSection, int chunkSectionBlockPosX, int chunkSectionBlockPosY, int chunkSectionBlockPosZ, @NotNull BlockState blockState, boolean lock) {
        chunkSection.states.getAndSetUnchecked(chunkSectionBlockPosX, chunkSectionBlockPosY, chunkSectionBlockPosZ, (Object)blockState);
        return blockState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    @Nullable
    private ChunkAccess lambda$fillFromNoise$11(@NotNull ChunkAccess chunk, int generationShapeHeightFloorDiv, @NotNull NoiseSettings generationShapeConfig, int minimumY, @NotNull Blender blender, @NotNull StructureManager structureAccessor, @NotNull RandomState noiseConfig, int minimumYFloorDiv) {
        ChunkAccess chunkWithNoise;
        int startingChunkSectionIndex = chunk.getSectionIndex(generationShapeHeightFloorDiv * generationShapeConfig.getCellHeight() - 1 + minimumY);
        int minimumYChunkSectionIndex = chunk.getSectionIndex(minimumY);
        LevelChunkSection[] chunkSections = chunk.getSections();
        for (int chunkSectionIndex = startingChunkSectionIndex; chunkSectionIndex >= minimumYChunkSectionIndex; --chunkSectionIndex) {
            chunkSections[chunkSectionIndex].acquire();
        }
        try {
            chunkWithNoise = this.doFill(blender, structureAccessor, noiseConfig, chunk, minimumYFloorDiv, generationShapeHeightFloorDiv);
        }
        finally {
            for (int chunkSectionIndex = startingChunkSectionIndex; chunkSectionIndex >= minimumYChunkSectionIndex; --chunkSectionIndex) {
                LevelChunkSection chunkSection = chunkSections[chunkSectionIndex];
                chunkSection.recalcBlockCounts();
                chunkSection.release();
            }
        }
        return chunkWithNoise;
    }
}

