/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ConfigLibClient;
import com.supermartijn642.configlib.ConfigSyncPacket;
import com.supermartijn642.configlib.ModConfig;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.resources.Identifier;
import net.minecraft.server.network.ConfigurationTask;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="supermartijn642configlib")
public class ConfigLib {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"configlib");
    private static final List<ModConfig<?>> CONFIGS = new ArrayList();
    private static final Set<String> CONFIG_NAMES = new HashSet<String>();
    private static final List<ModConfig<?>> SYNCABLE_CONFIGS = new ArrayList();
    private static final Map<String, ModConfig<?>> SYNCABLE_CONFIGS_BY_IDENTIFIER = new HashMap();

    public ConfigLib(IEventBus eventBus) {
        NeoForge.EVENT_BUS.addListener(e -> ConfigLib.onLoadGame());
        if (ConfigLib.isClientEnvironment()) {
            ConfigLibClient.registerEventListeners();
        }
        eventBus.addListener(e -> e.registrar("supermartijn642configlib").versioned(ConfigLib.getModVersion()).optional().configurationToClient(ConfigSyncPacket.TYPE, ConfigSyncPacket.CODEC, (p, c) -> {}));
        final ConfigurationTask.Type type = new ConfigurationTask.Type(Identifier.fromNamespaceAndPath((String)"supermartijn642configlib", (String)"sync_configs"));
        eventBus.addListener(e -> {
            final ServerConfigurationPacketListener listener = e.getListener();
            if (listener.hasChannel(ConfigSyncPacket.TYPE)) {
                e.register((ConfigurationTask)new ICustomConfigurationTask(){

                    public void run(Consumer<CustomPacketPayload> sender) {
                        ConfigLib.sendSyncConfigPackets(sender);
                        listener.finishCurrentTask(type);
                    }

                    public ConfigurationTask.Type type() {
                        return type;
                    }
                });
            }
        });
    }

    public static boolean isClientEnvironment() {
        return FMLEnvironment.getDist().isClient();
    }

    public static boolean isServerEnvironment() {
        return FMLEnvironment.getDist().isDedicatedServer();
    }

    public static String getModVersion() {
        return ((ModContainer)ModList.get().getModContainerById("supermartijn642configlib").orElseThrow()).getModInfo().getVersion().toString();
    }

    public static File getConfigFolder() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    protected static synchronized void addConfig(ModConfig<?> config) {
        if (CONFIG_NAMES.contains(config.getIdentifier())) {
            throw new IllegalStateException("Config '" + config.getIdentifier() + "' for mod '" + config.getModid() + "' already exists!");
        }
        CONFIGS.add(config);
        CONFIG_NAMES.add(config.getIdentifier());
        if (config.hasSyncableEntries()) {
            SYNCABLE_CONFIGS.add(config);
            SYNCABLE_CONFIGS_BY_IDENTIFIER.put(config.getIdentifier(), config);
        }
        config.initialize();
    }

    protected static void onLoadGame() {
        CONFIGS.forEach(ModConfig::onJoinGame);
    }

    protected static void onLeaveGame() {
        CONFIGS.forEach(ModConfig::onLeaveGame);
    }

    private static void sendSyncConfigPackets(Consumer<CustomPacketPayload> consumer) {
        for (ModConfig<?> config : SYNCABLE_CONFIGS) {
            consumer.accept(new ConfigSyncPacket(config));
        }
    }

    protected static void writeSyncedEntriesPacket(FriendlyByteBuf buffer, ConfigSyncPacket packet) {
        ModConfig<?> config = packet.config;
        buffer.writeUtf(config.getIdentifier());
        try {
            config.writeSyncableEntries((ByteBuf)buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", e);
        }
    }

    protected static ConfigSyncPacket handleSyncConfigPacket(FriendlyByteBuf buffer) {
        String identifier = buffer.readUtf();
        ModConfig<?> config = SYNCABLE_CONFIGS_BY_IDENTIFIER.get(identifier);
        if (config == null) {
            throw new RuntimeException("Received config sync packet for unknown config '" + identifier + "'!");
        }
        try {
            config.readSyncableValues((ByteBuf)buffer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", (Throwable)e);
        }
        return new ConfigSyncPacket();
    }
}

