/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.config.state;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.state.ConfigState;
import dev.worldgen.tectonic.config.state.V1ConfigState;
import dev.worldgen.tectonic.config.state.object.HeightLimits;
import dev.worldgen.tectonic.config.state.object.NoiseState;

public class V2ConfigState {
    public static final Codec<V2ConfigState> BASE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").forGetter(config -> config.enabled), (App)Toggles.CODEC.fieldOf("feature_toggles").orElse((Object)Toggles.DEFAULT).forGetter(config -> config.toggles), (App)Scales.CODEC.fieldOf("terrain_scales").orElse((Object)Scales.DEFAULT).forGetter(config -> config.scales), (App)Codec.INT.fieldOf("snow_start_offset").orElse((Object)128).forGetter(config -> config.snowOffset)).apply((Applicative)instance, V2ConfigState::new));
    public static final Codec<V2ConfigState> CODEC = Tectonic.withAlternative(BASE_CODEC, V1ConfigState.CODEC, V1ConfigState::upgrade);
    public boolean enabled;
    public Toggles toggles;
    public Scales scales;
    public int snowOffset;

    public V2ConfigState(boolean enabled, Toggles toggles, Scales scales, int snowOffset) {
        this.enabled = enabled;
        this.toggles = toggles;
        this.scales = scales;
        this.snowOffset = snowOffset;
    }

    public ConfigState upgrade() {
        return new ConfigState(1, new ConfigState.General(this.enabled, this.snowOffset), new ConfigState.GlobalTerrain(this.scales.finalMultiplier, 0.0, HeightLimits.defaultLimits(this.toggles.increasedHeight), this.toggles.lavaRivers, false), new ConfigState.Continents(-0.8, 0.13, this.scales.erosionScale, 0.25, this.toggles.undergroundRivers, true, false, 0.1, true, true), ConfigState.Islands.DEFAULT, new ConfigState.Oceans(this.scales.ocean, this.scales.deepOcean, this.toggles.monumentOffset ? -30 : 0, false), new ConfigState.Biomes(NoiseState.DEFAULT, NoiseState.DEFAULT), ConfigState.Caves.DEFAULT);
    }

    public static class Toggles {
        public static final Codec<Toggles> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("desert_dunes").orElse((Object)true).forGetter(toggles -> toggles.dunes), (App)Codec.BOOL.fieldOf("underground_rivers").orElse((Object)true).forGetter(toggles -> toggles.undergroundRivers), (App)Codec.BOOL.fieldOf("lava_rivers").orElse((Object)true).forGetter(toggles -> toggles.lavaRivers), (App)Codec.BOOL.fieldOf("monument_offset").orElse((Object)true).forGetter(toggles -> toggles.monumentOffset), (App)Codec.BOOL.fieldOf("increased_height").orElse((Object)false).forGetter(toggles -> toggles.increasedHeight)).apply((Applicative)instance, Toggles::new));
        public static final Toggles DEFAULT = new Toggles(true, true, true, true, false);
        public boolean dunes;
        public boolean undergroundRivers;
        public boolean lavaRivers;
        public boolean monumentOffset;
        public boolean increasedHeight;

        public Toggles(boolean dunes, boolean undergroundRivers, boolean lavaRivers, boolean monumentOffset, boolean increasedHeight) {
            this.dunes = dunes;
            this.undergroundRivers = undergroundRivers;
            this.lavaRivers = lavaRivers;
            this.monumentOffset = monumentOffset;
            this.increasedHeight = increasedHeight;
        }
    }

    public static class Scales {
        public static final Codec<Scales> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("vertical_multiplier").orElse((Object)1.125).forGetter(scales -> scales.finalMultiplier), (App)Codec.DOUBLE.fieldOf("erosion_scale").orElse((Object)0.25).forGetter(scales -> scales.erosionScale), (App)Codec.DOUBLE.fieldOf("ocean_depth").orElse((Object)-0.15).forGetter(scales -> scales.ocean), (App)Codec.DOUBLE.fieldOf("deep_ocean_depth").orElse((Object)-0.45).forGetter(scales -> scales.deepOcean)).apply((Applicative)instance, Scales::new));
        public static final Scales DEFAULT = new Scales(1.125, 0.25, -0.15, -0.45);
        public double finalMultiplier;
        public double erosionScale;
        public double ocean;
        public double deepOcean;

        public Scales(double finalMultiplier, double erosionScale, double ocean, double deepOcean) {
            this.finalMultiplier = finalMultiplier;
            this.erosionScale = erosionScale;
            this.ocean = ocean;
            this.deepOcean = deepOcean;
        }
    }
}

